/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.polish.extensions.item;

import com.youversion.objects.Note;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class NoteItem
extends Container {
    protected Note note;

    public NoteItem(Note note) {
        super(StyleSheet.noteStyle);
        this.note = note;
        Container headerList = new Container(false, StyleSheet.note_headerStyle);
        StringItem titleItem = new StringItem(null, this.note.getTitle(), 0, StyleSheet.note_titleStyle);
        headerList.add(titleItem);
        StringItem date = new StringItem(null, Locale.formatDate(this.note.getCreated()), StyleSheet.note_modeStyle);
        headerList.add(date);
        this.add(headerList);
        StringItem textItem = new StringItem(null, this.note.getContentText(), 0, StyleSheet.note_textStyle);
        this.add(textItem);
        String noteMode = this.note.getUserStatus();
        String noteModeText = null;
        if ("draft".equals(noteMode)) {
            noteModeText = Locale.get(67);
        } else if ("private".equals(noteMode)) {
            noteModeText = Locale.get(69);
        }
        StringItem publicModeItem = new StringItem(null, noteModeText, 0, StyleSheet.note_modeStyle);
        this.add(publicModeItem);
    }

    public Note getNote() {
        return this.note;
    }
}

