/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.util.JsonHelper;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.json.me.JSONObject;

public class User
implements Externalizable {
    protected int id;
    protected String name;
    protected String username;
    protected String firstName;
    protected String lastName;
    protected String location;
    protected String imType;
    protected String imUsername;
    protected String website;
    protected String phoneMobile;
    protected String language;
    protected String noticeContribFav;
    protected String noticeFollower;
    protected String noticeNewsletter;
    protected String postalCode;
    protected String country;
    protected String timezone;
    protected String avatarUrl;
    protected String created;
    protected String lastLogin;
    protected String email;
    protected TwitterInfo twitter;
    protected FacebookInfo facebook;

    public static User unloadJSON(JSONObject json) throws YouVersionApiException {
        Throwable innerEx = null;
        try {
            User obj = ApiBase.getApiFactory().newUser();
            obj.id = JsonHelper.getInt(json, "id");
            obj.name = JsonHelper.getString(json, "name");
            obj.username = JsonHelper.getString(json, "username");
            obj.firstName = JsonHelper.getString(json, "first_name");
            obj.lastName = JsonHelper.getString(json, "last_name");
            obj.location = JsonHelper.getString(json, "location");
            obj.imType = JsonHelper.getString(json, "im_type");
            obj.imUsername = JsonHelper.getString(json, "im_username");
            obj.website = JsonHelper.getString(json, "website");
            obj.phoneMobile = JsonHelper.getString(json, "phone_mobile");
            obj.language = JsonHelper.getString(json, "language");
            obj.noticeContribFav = JsonHelper.getString(json, "notice_contrib_fav");
            obj.noticeFollower = JsonHelper.getString(json, "notice_follower");
            obj.noticeNewsletter = JsonHelper.getString(json, "notice_newsletter");
            obj.postalCode = JsonHelper.getString(json, "postal_code");
            obj.country = JsonHelper.getString(json, "country");
            obj.timezone = JsonHelper.getString(json, "timezone");
            JSONObject avatarGroup = json.getJSONObject("user_avatar_url");
            obj.avatarUrl = JsonHelper.getString(avatarGroup, "px_48x48");
            obj.created = JsonHelper.getString(json, "created");
            obj.lastLogin = JsonHelper.getString(json, "last_login");
            obj.email = JsonHelper.getString(json, "email");
            if (json.has("twitter") && !json.isNull("twitter")) {
                JSONObject twitter = json.getJSONObject("twitter");
                TwitterInfo ti = ApiBase.getApiFactory().newTwitterInfo();
                ti.userId = twitter.getString("user_id");
                ti.screenName = twitter.getString("screen_name");
                ti.oauthToken = twitter.getString("oauth_token");
                ti.oauthSecret = twitter.getString("oauth_token_secret");
                obj.setTwitter(ti);
            }
            if (json.has("facebook") && !json.isNull("facebook")) {
                JSONObject facebook = json.getJSONObject("facebook");
                FacebookInfo fb = ApiBase.getApiFactory().newFacebookInfo();
                fb.userId = facebook.getString("user_id");
                fb.name = facebook.getString("name");
                fb.accessToken = facebook.getString("access_token");
                obj.setFacebook(fb);
            }
            return obj;
        }
        catch (Throwable t) {
            innerEx = t;
            throw new YouVersionApiException("User.unloadJSON failed: " + innerEx.getMessage(), innerEx);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getImType() {
        return this.imType;
    }

    public void setImType(String imType) {
        this.imType = imType;
    }

    public String getImUsername() {
        return this.imUsername;
    }

    public void setImUsername(String imUsername) {
        this.imUsername = imUsername;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getPhoneMobile() {
        return this.phoneMobile;
    }

    public void setPhoneMobile(String phoneMobile) {
        this.phoneMobile = phoneMobile;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getNoticeContribFav() {
        return this.noticeContribFav;
    }

    public void setNoticeContribFav(String noticeContribFav) {
        this.noticeContribFav = noticeContribFav;
    }

    public String getNoticeFollower() {
        return this.noticeFollower;
    }

    public void setNoticeFollower(String noticeFollower) {
        this.noticeFollower = noticeFollower;
    }

    public String getNoticeNewsletter() {
        return this.noticeNewsletter;
    }

    public void setNoticeNewsletter(String noticeNewsletter) {
        this.noticeNewsletter = noticeNewsletter;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(String lastLogin) {
        this.lastLogin = lastLogin;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setTwitter(TwitterInfo twitter) {
        this.twitter = twitter;
    }

    public TwitterInfo getTwitter() {
        return this.twitter;
    }

    public void setFacebook(FacebookInfo facebook) {
        this.facebook = facebook;
    }

    public FacebookInfo getFacebook() {
        return this.facebook;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.avatarUrl = (String)Serializer.deserialize(dataInputStream);
        this.country = (String)Serializer.deserialize(dataInputStream);
        this.created = (String)Serializer.deserialize(dataInputStream);
        this.email = (String)Serializer.deserialize(dataInputStream);
        this.facebook = (FacebookInfo)Serializer.deserialize(dataInputStream);
        this.firstName = (String)Serializer.deserialize(dataInputStream);
        this.id = dataInputStream.readInt();
        this.imType = (String)Serializer.deserialize(dataInputStream);
        this.imUsername = (String)Serializer.deserialize(dataInputStream);
        this.language = (String)Serializer.deserialize(dataInputStream);
        this.lastLogin = (String)Serializer.deserialize(dataInputStream);
        this.lastName = (String)Serializer.deserialize(dataInputStream);
        this.location = (String)Serializer.deserialize(dataInputStream);
        this.name = (String)Serializer.deserialize(dataInputStream);
        this.noticeContribFav = (String)Serializer.deserialize(dataInputStream);
        this.noticeFollower = (String)Serializer.deserialize(dataInputStream);
        this.noticeNewsletter = (String)Serializer.deserialize(dataInputStream);
        this.phoneMobile = (String)Serializer.deserialize(dataInputStream);
        this.postalCode = (String)Serializer.deserialize(dataInputStream);
        this.timezone = (String)Serializer.deserialize(dataInputStream);
        this.twitter = (TwitterInfo)Serializer.deserialize(dataInputStream);
        this.username = (String)Serializer.deserialize(dataInputStream);
        this.website = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this.avatarUrl, dataOutputStream);
        Serializer.serialize(this.country, dataOutputStream);
        Serializer.serialize(this.created, dataOutputStream);
        Serializer.serialize(this.email, dataOutputStream);
        Serializer.serialize(this.facebook, dataOutputStream);
        Serializer.serialize(this.firstName, dataOutputStream);
        dataOutputStream.writeInt(this.id);
        Serializer.serialize(this.imType, dataOutputStream);
        Serializer.serialize(this.imUsername, dataOutputStream);
        Serializer.serialize(this.language, dataOutputStream);
        Serializer.serialize(this.lastLogin, dataOutputStream);
        Serializer.serialize(this.lastName, dataOutputStream);
        Serializer.serialize(this.location, dataOutputStream);
        Serializer.serialize(this.name, dataOutputStream);
        Serializer.serialize(this.noticeContribFav, dataOutputStream);
        Serializer.serialize(this.noticeFollower, dataOutputStream);
        Serializer.serialize(this.noticeNewsletter, dataOutputStream);
        Serializer.serialize(this.phoneMobile, dataOutputStream);
        Serializer.serialize(this.postalCode, dataOutputStream);
        Serializer.serialize(this.timezone, dataOutputStream);
        Serializer.serialize(this.twitter, dataOutputStream);
        Serializer.serialize(this.username, dataOutputStream);
        Serializer.serialize(this.website, dataOutputStream);
    }

    public static class FacebookInfo
    implements Externalizable {
        protected String userId;
        protected String name;
        protected String accessToken;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String id) {
            this.userId = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            this.accessToken = (String)Serializer.deserialize(dataInputStream);
            this.name = (String)Serializer.deserialize(dataInputStream);
            this.userId = (String)Serializer.deserialize(dataInputStream);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            Serializer.serialize(this.accessToken, dataOutputStream);
            Serializer.serialize(this.name, dataOutputStream);
            Serializer.serialize(this.userId, dataOutputStream);
        }
    }

    public static class TwitterInfo
    implements Externalizable {
        protected String userId;
        protected String screenName;
        protected String oauthToken;
        protected String oauthSecret;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getScreenName() {
            return this.screenName;
        }

        public void setScreenName(String screenName) {
            this.screenName = screenName;
        }

        public String getOauthToken() {
            return this.oauthToken;
        }

        public void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        public String getOauthSecret() {
            return this.oauthSecret;
        }

        public void setOauthSecret(String oauthSecret) {
            this.oauthSecret = oauthSecret;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            this.oauthSecret = (String)Serializer.deserialize(dataInputStream);
            this.oauthToken = (String)Serializer.deserialize(dataInputStream);
            this.screenName = (String)Serializer.deserialize(dataInputStream);
            this.userId = (String)Serializer.deserialize(dataInputStream);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            Serializer.serialize(this.oauthSecret, dataOutputStream);
            Serializer.serialize(this.oauthToken, dataOutputStream);
            Serializer.serialize(this.screenName, dataOutputStream);
            Serializer.serialize(this.userId, dataOutputStream);
        }
    }
}

