/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanAdjustedDayCollection;
import com.youversion.util.JsonHelper;
import org.json.me.JSONObject;

public class ReadingPlanDay {
    protected ReadingPlan plan;
    protected int current = 1;
    protected int next;
    protected int prev;
    protected int totalReadings;
    protected String shortUrl;
    protected boolean subscribed;
    protected String additionalContent;
    protected ReadingPlanAdjustedDayCollection adjustedDays;

    public static ReadingPlanDay unloadJSON(JSONObject json) throws YouVersionApiException {
        Throwable innerEx = null;
        try {
            ReadingPlanDay obj = ApiBase.getApiFactory().newReadingPlanDay();
            obj.plan = ReadingPlan.unloadJSON(json);
            obj.shortUrl = JsonHelper.getString(json, "short_url");
            obj.next = JsonHelper.getInt(json, "next");
            obj.prev = JsonHelper.getInt(json, "prev");
            obj.setTotalReadings(JsonHelper.getInt(json, "total_readings"));
            obj.subscribed = JsonHelper.getBoolean(json, "subscribed");
            obj.setAdditionalContent(JsonHelper.getLocaleString(json, "additional_content"));
            obj.adjustedDays = ReadingPlanAdjustedDayCollection.unloadJSON(json.getJSONArray("adjusted_days"));
            return obj;
        }
        catch (Throwable t) {
            innerEx = t;
            throw new YouVersionApiException("ReadingPlan.unloadJSON failed: " + innerEx.getMessage(), innerEx);
        }
    }

    public ReadingPlan getPlan() {
        return this.plan;
    }

    public void setPlan(ReadingPlan plan) {
        this.plan = plan;
    }

    public boolean hasNext() {
        return this.next != 0;
    }

    public boolean hasPrev() {
        return this.prev != 0;
    }

    public int getNext() {
        return this.next;
    }

    public void setNext(int next) {
        this.next = next;
    }

    public int getPrev() {
        return this.prev;
    }

    public void setPrev(int prev) {
        this.prev = prev;
    }

    public ReadingPlanAdjustedDayCollection getAdjustedDays() {
        return this.adjustedDays;
    }

    public void setAdjustedDays(ReadingPlanAdjustedDayCollection adjustedDays) {
        this.adjustedDays = adjustedDays;
    }

    public void setTotalReadings(int totalReadings) {
        this.totalReadings = totalReadings;
    }

    public int getTotalReadings() {
        return this.totalReadings;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public String getShortUrl() {
        return this.shortUrl;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setAdditionalContent(String additionalContent) {
        this.additionalContent = additionalContent == null ? null : additionalContent.trim();
    }

    public String getAdditionalContent() {
        return this.additionalContent;
    }

    public boolean hasAdditionalContent() {
        return this.additionalContent != null && !this.additionalContent.equals("");
    }
}

