/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.Note;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class NoteCollection
extends Vector {
    protected int total;

    public static NoteCollection unloadJSON(JSONObject json) {
        NoteCollection emptyCollection = ApiBase.getApiFactory().newNoteCollection();
        if (json == null) {
            return emptyCollection;
        }
        NoteCollection collection = ApiBase.getApiFactory().newNoteCollection();
        JSONArray items = null;
        try {
            collection.total = json.getInt("total");
            items = json.getJSONArray("notes");
        }
        catch (JSONException e) {
            ApiBase.getDebugHelper().logError("NoteCollection::unloadJSON failed", e);
            return emptyCollection;
        }
        for (int i = 0; i < items.length(); ++i) {
            JSONObject item;
            try {
                item = items.getJSONObject(i);
            }
            catch (JSONException e) {
                ApiBase.getDebugHelper().logError("NoteCollection::unloadJSON failed", e);
                return emptyCollection;
            }
            try {
                collection.addElement(Note.unloadJSON(item));
                continue;
            }
            catch (YouVersionApiException e) {
                ApiBase.getDebugHelper().logError("NoteCollection::unloadJSON failed", e);
                return emptyCollection;
            }
        }
        return collection;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getTotal() {
        return this.total;
    }
}

