/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.ReferenceCollection;
import com.youversion.util.DateParser;
import com.youversion.util.JsonHelper;
import java.util.Date;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Note {
    public static final String DRAFT = "draft";
    public static final String PRIVATE = "private";
    public static final String PUBLIC = "public";
    public static final String INVALID = "invalid";
    public static final String NEW = "new";
    public static final String IN_REVIEW = "in_review";
    public static final String APPROVED = "approved";
    public static final String INAPPROPRIATE = "inappropriate";
    protected long id;
    protected int userId;
    protected String username;
    protected String userAvatarUrl;
    protected String title;
    protected String url;
    protected String shortUrl;
    protected String contentYvml;
    protected String contentHtml;
    protected String contentHtmlAndroid;
    protected String contentHtmlIos;
    protected String contentText;
    protected boolean richContent;
    protected String languageIso;
    protected int rank;
    protected ReferenceCollection references = ApiBase.getApiFactory().newReferenceCollection();
    protected String version;
    protected Date created;
    protected Date published;
    protected Date updated;
    protected String userStatus;
    protected String systemStatus;
    protected String highlightColor;

    public static Note unloadJSON(JSONObject json) throws YouVersionApiException {
        Throwable innerEx = null;
        try {
            Note note = ApiBase.getApiFactory().newNote();
            note.setId(json.getLong("id"));
            note.setUserId(json.getInt("user_id"));
            note.setUsername(json.getString("username"));
            JSONObject avatarUrls = json.getJSONObject("user_avatar_url");
            note.setUserAvatarUrl(avatarUrls.getString("px_48x48"));
            note.setTitle(json.getString("title"));
            note.setUrl(json.getString("url"));
            note.setShortUrl(json.getString("short_url"));
            note.setRichContent(json.getBoolean("rich_content"));
            note.setContentYvml(json.optString("content_yvml", null));
            note.setContentHtml(json.optString("content_html", null));
            note.setContentHtmlAndroid(json.optString("content_html_android", null));
            note.setContentHtmlIos(json.optString("content_html_ios", null));
            note.setContentText(json.getString("content_text"));
            note.setLanguageIso(json.optString("language_iso", null));
            note.setRank(json.getInt("rank"));
            try {
                note.setReferences(ReferenceCollection.unloadJSON(json.getJSONArray("reference")));
            }
            catch (JSONException e) {
                // empty catch block
            }
            note.setVersion(json.getString("version"));
            note.setCreated(new Date(DateParser.parseISO(json.getString("created"))));
            note.setUpdated(new Date(DateParser.parseISO(json.getString("updated"))));
            String published = json.optString("published", null);
            if (published != null && !published.equals("null")) {
                note.setPublished(new Date(DateParser.parseISO(published)));
            }
            note.setUserStatus(json.getString("user_status"));
            note.setSystemStatus(json.getString("system_status"));
            note.setHighlightColor(JsonHelper.getString(json, "highlight_color", null));
            return note;
        }
        catch (Throwable t) {
            innerEx = t;
            throw new YouVersionApiException("Note.unloadJSON failed: " + innerEx.getMessage(), innerEx);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public ReferenceCollection getReferences() {
        return this.references;
    }

    public void setReferences(ReferenceCollection references) {
        this.references = references;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getShortUrl() {
        return this.shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserAvatarUrl() {
        return this.userAvatarUrl;
    }

    public void setUserAvatarUrl(String userAvatarUrl) {
        this.userAvatarUrl = userAvatarUrl;
    }

    public String getContentYvml() {
        return this.contentYvml;
    }

    public void setContentYvml(String contentYvml) {
        this.contentYvml = contentYvml;
    }

    public String getContentHtml() {
        return this.contentHtml;
    }

    public void setContentHtml(String contentHtml) {
        this.contentHtml = contentHtml;
    }

    public String getContentHtmlAndroid() {
        return this.contentHtmlAndroid;
    }

    public void setContentHtmlAndroid(String contentHtmlAndroid) {
        this.contentHtmlAndroid = contentHtmlAndroid;
    }

    public String getContentHtmlIos() {
        return this.contentHtmlIos;
    }

    public void setContentHtmlIos(String contentHtmlIos) {
        this.contentHtmlIos = contentHtmlIos;
    }

    public String getContentText() {
        return this.contentText;
    }

    public void setContentText(String contentText) {
        this.contentText = contentText;
    }

    public boolean isRichContent() {
        return this.richContent;
    }

    public void setRichContent(boolean richContent) {
        this.richContent = richContent;
    }

    public String getLanguageIso() {
        return this.languageIso;
    }

    public void setLanguageIso(String languageIso) {
        this.languageIso = languageIso == null || languageIso.equals("null") ? null : languageIso;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getPublished() {
        return this.published;
    }

    public void setPublished(Date published) {
        this.published = published;
    }

    public String getUserStatus() {
        return this.userStatus;
    }

    public void setUserStatus(String userStatus) {
        this.userStatus = userStatus.equals(DRAFT) ? DRAFT : (userStatus.equals(PRIVATE) ? PRIVATE : (userStatus.equals(PUBLIC) ? PUBLIC : INVALID));
    }

    public String getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(String systemStatus) {
        this.systemStatus = systemStatus;
    }

    public String getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(String highlightColor) {
        this.highlightColor = highlightColor;
    }
}

