/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.LiveEventItem;
import com.youversion.objects.VerseCollection;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class LiveEventItemReference
extends LiveEventItem {
    protected String osis;
    protected String human;
    protected String version;
    protected VerseCollection verses;
    protected String copyright;

    public void unloadJSON(JSONObject json) throws YouVersionApiException {
        super.unloadJSON(json);
        try {
            ApiBase.getDebugHelper().logDebug(this.data);
            JSONObject jdata = new JSONObject(this.data);
            JSONObject jInnerData = jdata.getJSONObject("data");
            JSONObject jref = jdata.getJSONObject("reference");
            this.osis = jref.getString("osis");
            this.human = jref.getString("human");
            this.version = jdata.getString("version");
            this.verses = VerseCollection.unloadJSON(jInnerData.getJSONArray("items"));
            this.copyright = jInnerData.getString("copyright");
        }
        catch (JSONException t) {
            throw new YouVersionApiException("LiveEventItem.unloadJSON failed: " + t.getMessage(), t);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public VerseCollection getVerses() {
        return this.verses;
    }

    public void setVerses(VerseCollection verses) {
        this.verses = verses;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setOsis(String osis) {
        this.osis = osis;
    }

    public String getOsis() {
        return this.osis;
    }

    public void setHuman(String human) {
        this.human = human;
    }

    public String getHuman() {
        return this.human;
    }
}

