/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.LiveEventItem;
import com.youversion.util.StringHelper;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class LiveEventItemGiving
extends LiveEventItem {
    public static final int GIVING_TYPE_UNKNOWN = 0;
    public static final int GIVING_TYPE_PAYPAL = 1;
    protected int givingType;
    protected String givingData;
    protected String description;

    public void unloadJSON(JSONObject json) throws YouVersionApiException {
        super.unloadJSON(json);
        try {
            JSONObject jdata = new JSONObject(this.data);
            this.givingType = LiveEventItemGiving.parseGivingType(jdata.getString("giving_type"));
            this.givingData = jdata.getString("giving_data");
            this.description = jdata.getString("description");
        }
        catch (JSONException t) {
            throw new YouVersionApiException("LiveEventItem.unloadJSON failed: " + t.getMessage(), t);
        }
    }

    public static int parseGivingType(String type) {
        if (type == null) {
            return 0;
        }
        if (StringHelper.equalsIgnoreCase("paypal_donation", type.trim())) {
            return 1;
        }
        return 0;
    }

    public int getGivingType() {
        return this.givingType;
    }

    public void setGivingType(int givingType) {
        this.givingType = givingType;
    }

    public String getGivingData() {
        return this.givingData;
    }

    public void setGivingData(String givingData) {
        this.givingData = givingData;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

