/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import org.json.me.JSONObject;

public class GroupLocation {
    protected int locationId;
    protected int groupId;
    protected String locationName;
    protected String street1;
    protected String street2;
    protected String street3;
    protected String city;
    protected Integer stateId = null;
    protected String stateName = null;
    protected String stateAbbrev = null;
    protected String province;
    protected String country;
    protected String postalCode;
    protected double geoLatitude;
    protected double geoLongitude;
    protected double distance;

    public static GroupLocation unloadJSON(JSONObject json) throws YouVersionApiException {
        Throwable innerEx = null;
        try {
            GroupLocation obj = ApiBase.getApiFactory().newGroupLocation();
            obj.locationId = json.getInt("id");
            obj.groupId = json.getInt("group_id");
            obj.locationName = json.getString("name");
            obj.street1 = json.getString("street_1");
            obj.street2 = json.getString("street_2");
            obj.street3 = json.getString("street_3");
            obj.city = json.getString("city");
            if (!json.isNull("state_id")) {
                obj.setStateId(new Integer(json.getInt("state_id")));
            }
            if (!json.isNull("state_name")) {
                obj.setStateName(json.getString("state_name"));
            }
            if (!json.isNull("state_abbrev")) {
                obj.setStateAbbrev(json.getString("state_abbrev"));
            }
            obj.province = json.getString("province");
            obj.country = json.getString("country");
            obj.postalCode = json.getString("postal_code");
            obj.geoLatitude = json.getDouble("geo_latitude");
            obj.geoLongitude = json.getDouble("geo_longitude");
            obj.distance = json.getDouble("distance");
            return obj;
        }
        catch (Throwable t) {
            innerEx = t;
            throw new YouVersionApiException("GroupLocation.unloadJSON failed: " + innerEx.getMessage(), innerEx);
        }
    }

    public int getLocationId() {
        return this.locationId;
    }

    public void setLocationId(int locationId) {
        this.locationId = locationId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getStreet1() {
        return this.street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public String getStreet3() {
        return this.street3;
    }

    public void setStreet3(String street3) {
        this.street3 = street3;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public double getGeoLatitude() {
        return this.geoLatitude;
    }

    public void setGeoLatitude(double geoLatitude) {
        this.geoLatitude = geoLatitude;
    }

    public double getGeoLongitude() {
        return this.geoLongitude;
    }

    public void setGeoLongitude(double geoLongitude) {
        this.geoLongitude = geoLongitude;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setStateId(Integer stateId) {
        this.stateId = stateId;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateAbbrev(String stateAbbrev) {
        this.stateAbbrev = stateAbbrev;
    }

    public String getStateAbbrev() {
        return this.stateAbbrev;
    }
}

