/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.objects.Bookmark;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class BookmarkCollection
extends Vector
implements Externalizable {
    protected int total = 0;

    public static BookmarkCollection unloadJSON(JSONObject data) throws JSONException {
        BookmarkCollection emptyCollection = ApiBase.getApiFactory().newBookmarkCollection();
        if (data == null) {
            return emptyCollection;
        }
        BookmarkCollection collection = ApiBase.getApiFactory().newBookmarkCollection();
        collection.total = data.getInt("total");
        JSONArray items = data.getJSONArray("bookmarks");
        for (int i = 0; i < items.length(); ++i) {
            JSONObject item;
            try {
                item = items.getJSONObject(i);
            }
            catch (JSONException e) {
                return emptyCollection;
            }
            collection.addElement(Bookmark.unloadJSON(item));
        }
        return collection;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getTotal() {
        return this.total;
    }

    public void write(DataOutputStream out) throws IOException {
        int size = this.size();
        out.writeInt(size);
        out.writeInt(this.total);
        for (int i = 0; i < size; ++i) {
            Serializer.serialize(this.elementAt(i), out);
        }
    }

    public void read(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.total = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object value = Serializer.deserialize(in);
            this.addElement(value);
        }
    }
}

