/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.Book;
import com.youversion.util.CollectionHelper;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class BookCollection
implements Externalizable {
    protected Vector _books = new Vector();
    protected Vector _booksAlpha = new Vector();
    protected Hashtable _booksByAbbrev = new Hashtable();

    public void add(Book b) {
        this._books.addElement(b);
        this._booksByAbbrev.put(b.getAbbreviation().toLowerCase(), b);
        this.addAlpha(b);
    }

    private void addAlpha(Book newBook) {
        for (int i = 0; i < this._booksAlpha.size(); ++i) {
            Book book = (Book)this._booksAlpha.elementAt(i);
            if (book.getHuman().compareTo(newBook.getHuman()) <= 0) continue;
            this._booksAlpha.insertElementAt(newBook, i);
            return;
        }
        this._booksAlpha.addElement(newBook);
    }

    public boolean containsKey(String abbreviation) {
        return this._booksByAbbrev.containsKey(abbreviation.toLowerCase());
    }

    public Vector getOrdered() {
        return CollectionHelper.clone(this._books);
    }

    public Vector getAlphabetical() {
        return CollectionHelper.clone(this._booksAlpha);
    }

    public Book get(String abbreviation) {
        if (abbreviation == null) {
            return null;
        }
        return (Book)this._booksByAbbrev.get(abbreviation.toLowerCase());
    }

    public int size() {
        return this._books.size();
    }

    public static BookCollection unloadResponse(String response) throws JSONException, YouVersionApiException {
        YouVersionApiException innerEx = null;
        BookCollection collection = ApiBase.getApiFactory().newBookCollection();
        try {
            JSONObject parsed = new JSONObject(response).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ApiBase.isSuccess(code)) {
                JSONArray data = parsed.getJSONArray("data");
                for (int i = 0; i < data.length(); ++i) {
                    collection.add(Book.unloadJson(data.getJSONObject(i)));
                }
                return collection;
            }
            innerEx = ApiBase.buildReadException(parsed);
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this._books = (Vector)Serializer.deserialize(dataInputStream);
        this._booksAlpha = (Vector)Serializer.deserialize(dataInputStream);
        this._booksByAbbrev = (Hashtable)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this._books, dataOutputStream);
        Serializer.serialize(this._booksAlpha, dataOutputStream);
        Serializer.serialize(this._booksByAbbrev, dataOutputStream);
    }
}

