/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Book
implements Externalizable {
    protected int number;
    protected String abbreviation;
    protected String human;
    protected int chapters;
    protected Vector verses = new Vector();
    protected boolean audio;

    public Book() {
    }

    public Book(String abbreviation, String human, int chapters, int number) {
        this.abbreviation = abbreviation;
        this.human = human;
        this.chapters = chapters;
        this.number = number;
    }

    public String toString() {
        return this.human;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getHuman() {
        return this.human;
    }

    public void setHuman(String human) {
        this.human = human;
    }

    public int getChapters() {
        return this.chapters;
    }

    public void setChapters(int chapters) {
        this.chapters = chapters;
    }

    public Vector getVerses() {
        return this.verses;
    }

    public void setVerses(Vector verses) {
        this.verses = verses;
    }

    public boolean isAudio() {
        return this.audio;
    }

    public void setAudio(boolean audio) {
        this.audio = audio;
    }

    public static Book unloadJson(JSONObject obj) throws JSONException {
        Book b = ApiBase.getApiFactory().newBook();
        b.setAbbreviation(obj.getString("osis"));
        b.setChapters(obj.getInt("chapters"));
        b.setHuman(obj.getString("human"));
        b.setNumber(obj.getInt("number"));
        b.setAudio(obj.getBoolean("audio"));
        try {
            JSONArray jVerses = obj.getJSONArray("verses");
            int count = jVerses.length();
            for (int i = 0; i < count; ++i) {
                b.verses.addElement(new Integer(jVerses.getInt(i)));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return b;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.abbreviation = (String)Serializer.deserialize(dataInputStream);
        this.audio = dataInputStream.readBoolean();
        this.chapters = dataInputStream.readInt();
        this.human = (String)Serializer.deserialize(dataInputStream);
        this.number = dataInputStream.readInt();
        this.verses = (Vector)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this.abbreviation, dataOutputStream);
        dataOutputStream.writeBoolean(this.audio);
        dataOutputStream.writeInt(this.chapters);
        Serializer.serialize(this.human, dataOutputStream);
        dataOutputStream.writeInt(this.number);
        Serializer.serialize(this.verses, dataOutputStream);
    }
}

