/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.objects.BibleSearchResultItem;
import com.youversion.objects.BibleSearchResultItemCollection;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class BibleSearchResult {
    protected String request;
    protected String suggestion;
    protected BibleSearchResultItemCollection items = ApiBase.getApiFactory().newBibleSearchResultItemCollection();
    protected int total;
    protected Hashtable facets = new Hashtable();

    public void unloadJSON(JSONObject json) throws JSONException {
        this.setSuggestion(json.getString("suggestion"));
        this.setRequest(json.getString("request"));
        this.setTotal(json.getInt("total"));
        JSONArray jitems = json.getJSONArray("items");
        for (int i = 0; i < jitems.length(); ++i) {
            JSONObject item = jitems.getJSONObject(i);
            BibleSearchResultItem verse = ApiBase.getApiFactory().newBibleSearchResultItem();
            verse.unloadJSON(item);
            this.items.addElement(verse);
        }
        JSONObject facets = json.optJSONObject("facets");
        if (facets != null) {
            JSONArray names = facets.names();
            for (int i = 0; i < names.length(); ++i) {
                String name = names.getString(i);
                JSONObject facet = facets.getJSONObject(name);
                this.facets.put(name, FacetCollection.fromJson(facet));
            }
        }
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public BibleSearchResultItemCollection getVerses() {
        return this.items;
    }

    public void setVerses(BibleSearchResultItemCollection items) {
        this.items = items;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int size() {
        return this.items.size();
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public FacetCollection getFacets(String key) {
        return (FacetCollection)this.facets.get(key);
    }

    public static class FacetCollection {
        protected Vector data = new Vector();

        public Facet getItem(int index) {
            return (Facet)this.data.elementAt(index);
        }

        public static FacetCollection fromJson(JSONObject facet) throws JSONException {
            FacetCollection items = ApiBase.getApiFactory().newFacetCollection();
            JSONArray names = facet.names();
            for (int i = 0; i < names.length(); ++i) {
                String name = names.getString(i);
                int count = facet.getInt(name);
                Facet newFacet = ApiBase.getApiFactory().newFacet();
                newFacet.setName(name);
                newFacet.setCount(count);
                items.addElement(newFacet);
            }
            return items;
        }

        public void addElement(Facet item) {
            this.data.addElement(item);
        }

        public int size() {
            return this.data.size();
        }
    }

    public static class Facet {
        protected String name;
        protected int count;

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

