/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.internal;

import com.twmacinta.util.MD5;
import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.BibleApi;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.User;
import java.util.Calendar;
import java.util.Hashtable;
import org.json.me.JSONObject;

public class UsersApiPrivate
extends BibleApi {
    public static User updateTwitterConnection(ApiConnection conn, String username, String password, String oauthToken, String oauthTokenSecret, Integer userId, String screenName, String consumerKey, String consumerKeySecret) throws YouVersionApiException {
        return UsersApiPrivate.updateTwitterConnection(conn, username, password, oauthToken, oauthTokenSecret, userId, consumerKey, consumerKeySecret, "java-library");
    }

    public static User updateTwitterConnection(ApiConnection conn, String username, String password, final String oauthToken, final String oauthTokenSecret, final Integer userId, final String screenName, final String consumerKey, final String consumerKeySecret, final String platform) throws YouVersionApiException {
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (oauthToken != null) {
                    this.put("oauth_token", oauthToken);
                }
                if (oauthTokenSecret != null) {
                    this.put("oauth_token_secret", oauthTokenSecret);
                }
                if (userId != null) {
                    this.put("user_id", userId);
                }
                if (screenName != null) {
                    this.put("screen_name", screenName);
                }
                if (consumerKey != null) {
                    this.put("key", consumerKey);
                }
                if (consumerKeySecret != null) {
                    this.put("secret", consumerKeySecret);
                }
                if (platform != null) {
                    this.put("platform", platform);
                }
                this.put("created_dt", Calendar.getInstance().getTime());
            }
        };
        JSONObject twitter = new JSONObject(map);
        map.clear();
        map.put("twitter", twitter.toString());
        return UsersApiPrivate.setPartialProfile(conn, username, password, map);
    }

    public static User removeTwitterConnection(ApiConnection conn, String username, String password) throws YouVersionApiException {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("twitter", "null");
        return UsersApiPrivate.setPartialProfile(conn, username, password, map);
    }

    public static User updateFacebookConnection(ApiConnection conn, String username, String password, String accessToken, String userId, String name, String appId, String secret) throws YouVersionApiException {
        return UsersApiPrivate.updateFacebookConnection(conn, username, password, accessToken, userId, name, appId, secret, "java-library");
    }

    public static User updateFacebookConnection(ApiConnection conn, String username, String password, final String accessToken, final String userId, final String name, final String appId, final String secret, final String platform) throws YouVersionApiException {
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (accessToken != null) {
                    this.put("access_token", accessToken);
                }
                if (userId != null) {
                    this.put("user_id", userId);
                }
                if (name != null) {
                    this.put("name", name);
                }
                if (appId != null) {
                    this.put("appid", appId);
                }
                if (secret != null) {
                    this.put("secret", secret);
                }
                if (platform != null) {
                    this.put("platform", platform);
                }
                this.put("created_dt", Calendar.getInstance().getTime());
            }
        };
        JSONObject facebook = new JSONObject(map);
        map.clear();
        map.put("facebook", facebook.toString());
        return UsersApiPrivate.setPartialProfile(conn, username, password, map);
    }

    public static User removeFacebookConnection(ApiConnection conn, String username, String password) throws YouVersionApiException {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("facebook", "null");
        return UsersApiPrivate.setPartialProfile(conn, username, password, map);
    }

    public static User setPartialProfile(ApiConnection conn, String username, String password, Hashtable map) throws YouVersionApiException {
        YouVersionApiException ex = null;
        String url = ApiBase.URL_BASE + "/users/update_profile.json";
        try {
            byte[] postData = UsersApiPrivate.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, postData, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApiPrivate.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return User.unloadJSON(data);
            }
            ex = UsersApiPrivate.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            ex = e;
        }
        catch (Throwable e) {
            ex = new YouVersionApiException(e);
        }
        throw ex;
    }

    public static void create(ApiConnection conn, final String username, final String password, final String email, final Boolean agree, final Boolean verified) throws YouVersionApiException {
        YouVersionApiException ex = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (username != null) {
                    this.put("username", username);
                }
                if (password != null) {
                    this.put("password", password);
                }
                if (email != null) {
                    this.put("email", email);
                }
                if (agree != null) {
                    this.put("agree", agree);
                }
                if (verified != null) {
                    this.put("verified", verified);
                }
                if (ApiBase.getLocale() != null) {
                    this.put("locale", ApiBase.getLocale());
                }
            }
        };
        if (username != null && password != null) {
            String salt = ".Yv6-";
            MD5 md5 = new MD5((username + salt + password).getBytes());
            byte[] hash = md5.doFinal();
            map.put("token", MD5.toHex(hash).toLowerCase());
        }
        String url = ApiBase.URL_BASE_SSL + "/users/create.json";
        try {
            byte[] postData = UsersApiPrivate.mapToPostData(map);
            ApiConnection.ApiResponse response = conn.makePostRequest(url, postData);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (code != 201) {
                throw new YouVersionApiException(code, parsed.getString("data"));
            }
            return;
        }
        catch (YouVersionApiException e) {
            ex = e;
        }
        catch (Throwable e) {
            ex = new YouVersionApiException(e);
        }
        throw ex;
    }

    public static User updateLanguage(ApiConnection conn, String username, String password, String language, String country) throws YouVersionApiException {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("language", language);
        if (country != null) {
            map.put("country", country);
        }
        return UsersApiPrivate.setPartialProfile(conn, username, password, map);
    }

    public static void updateAvatar(ApiConnection conn, String username, String password, final String image) throws YouVersionApiException {
        YouVersionApiException ex = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (image != null) {
                    this.put("image", image);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/users/update_avatar.json";
        try {
            byte[] postData = UsersApiPrivate.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, postData, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApiPrivate.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return;
            }
            ex = UsersApiPrivate.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            ex = e;
        }
        catch (Throwable e) {
            ex = new YouVersionApiException(e);
        }
        throw ex;
    }
}

