/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.exceptions;

import com.youversion.ApiBase;
import com.youversion.objects.ApiError;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class YouVersionApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Throwable internal = null;
    private int statusCode = 0;
    private Vector errorMessages = new Vector();

    public YouVersionApiException(int statusCode, String data) {
        super(data);
        this.statusCode = statusCode;
        this.parseData(data);
    }

    public YouVersionApiException(String message) {
        super(message);
    }

    public YouVersionApiException(Throwable t) {
        super(t.getMessage());
        if (t instanceof YouVersionApiException) {
            YouVersionApiException e = (YouVersionApiException)t;
            this.statusCode = e.getStatusCode();
            this.internal = e.getInternalException();
        } else {
            this.internal = t;
        }
    }

    public YouVersionApiException(String message, Throwable t) {
        this(t);
    }

    private void parseData(String data) {
        try {
            this.errorMessages.removeAllElements();
            JSONArray errors = new JSONObject(data).getJSONArray("errors");
            for (int i = 0; i < errors.length(); ++i) {
                this.errorMessages.addElement(new ApiError(errors.getJSONObject(i)));
            }
        }
        catch (JSONException jsonEx) {
            ApiBase.getDebugHelper().logError("YouVersionApiException failed to parse errors.", jsonEx);
        }
    }

    public Throwable getInternalException() {
        return this.internal;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Vector getErrors() {
        return this.errorMessages;
    }
}

