/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.theme;

import com.youversion.application.global.NAVIGATION_HISTORY;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Theme {
    public void apply() {
        Style themeStyle = this.getThemeStyle();
        Style targetStyle = this.getTargetStyle();
        Hashtable stylesByName = StyleSheet.getStyles();
        Enumeration elements = stylesByName.elements();
        while (elements.hasMoreElements()) {
            Style style = (Style)elements.nextElement();
            if (!this.isAccepted(style.name)) continue;
            this.applyTheme(style, targetStyle, themeStyle);
        }
        NAVIGATION_HISTORY.resetStyle();
    }

    protected boolean isAccepted(String name) {
        int index;
        String[] acceptedNames = this.getAcceptedStyleNames();
        String[] filteredNames = this.getFilteredStyleNames();
        String[] themeNames = this.getThemeStyleNames();
        if (themeNames.length > 0) {
            for (index = 0; index < themeNames.length; ++index) {
                if (name.indexOf(themeNames[index]) == -1) continue;
                return false;
            }
        }
        if (filteredNames.length > 0) {
            for (index = 0; index < filteredNames.length; ++index) {
                if (name.indexOf(filteredNames[index]) == -1) continue;
                return false;
            }
        }
        if (acceptedNames.length > 0) {
            for (index = 0; index < acceptedNames.length; ++index) {
                if (name.indexOf(acceptedNames[index]) == -1) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    protected String[] getThemeStyleNames() {
        return new String[]{"theme_"};
    }

    protected String[] getAcceptedStyleNames() {
        return new String[0];
    }

    protected String[] getFilteredStyleNames() {
        return new String[0];
    }

    protected abstract Style getTargetStyle();

    protected abstract Style getThemeStyle();

    protected abstract void applyTheme(Style var1, Style var2, Style var3);
}

