/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.reader;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.reader.ChapterDescriptor;
import com.youversion.application.views.reader.BibleReaderChangeForm;
import com.youversion.objects.Language;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import java.util.Vector;

public class BibleLanguagesForm
extends BibleReaderChangeForm
implements ItemCommandListener {
    protected static final String KEY_LANGUAGE = "obj";

    public BibleLanguagesForm() {
        this((Style)null);
    }

    public BibleLanguagesForm(Style style) {
        super(style);
        BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
        ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
        Vector languages = workChapterDescriptor.getLanguages();
        for (int i = 0; i < languages.size(); ++i) {
            Language l = (Language)languages.elementAt(i);
            StringItem item = new StringItem(null, l.getHuman(), StyleSheet.list_itemStyle);
            item.setDefaultCommand(COMMANDS.CMD_SELECT);
            item.setItemCommandListener(this);
            item.setAttribute(KEY_LANGUAGE, l);
            this.container.add(item);
            System.out.println(l.getIso());
        }
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(27);
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
            ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
            Language language = (Language)item.getAttribute(KEY_LANGUAGE);
            workChapterDescriptor.setLanguage(language);
            EVENT_SYSTEM.queueEvent(990001);
        }
    }
}

