/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.plans;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.BibleReferenceManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.ReadingPlanAdjustedDayCollection;
import com.youversion.objects.ReadingPlanDay;
import com.youversion.objects.ReadingPlanReference;
import com.youversion.polish.extensions.item.PlanReferenceItem;
import com.youversion.polish.extensions.item.Spacer;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class BibleReadingPlanDayForm
extends BaseForm
implements ItemCommandListener,
CommandListener {
    protected static final String KEY_INDEX = "obj";
    protected ReadingPlanDay readingPlanDay;

    public BibleReadingPlanDayForm() {
        this((Style)null);
    }

    public BibleReadingPlanDayForm(Style style) {
        super(style);
    }

    public void setContent() {
        this.container.clear();
        this.removeAllCommands();
        this.readingPlanDay = BibleReferenceManager.getInstance().getReadingPlanDay();
        this.setTitle(this.getTitle());
        StringItem referencesLabel = new StringItem(null, Locale.get(96), StyleSheet.labelStyle);
        referencesLabel.setAppearanceMode(0);
        this.append(referencesLabel);
        ReadingPlanAdjustedDayCollection references = this.readingPlanDay.getAdjustedDays();
        for (int index = 0; index < this.readingPlanDay.getTotalReadings(); ++index) {
            ReadingPlanReference readingPlanReference = references.getReference(index);
            PlanReferenceItem referenceItem = new PlanReferenceItem(readingPlanReference, this.readingPlanDay);
            referenceItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            referenceItem.setAppearanceMode(3);
            referenceItem.setAttribute(KEY_INDEX, new Integer(index));
            referenceItem.setItemCommandListener(this);
            this.append(referenceItem);
        }
        if (this.readingPlanDay.getTotalReadings() == 0) {
            StringItem noReadings = new StringItem(null, Locale.get(104), 0, StyleSheet.itemStyle);
            this.append(noReadings);
        }
        if (this.readingPlanDay.hasAdditionalContent()) {
            Spacer separator = new Spacer(StyleSheet.spacerStyle);
            this.append(separator);
            StringItem additionalContentLabel = new StringItem(null, Locale.get(95), StyleSheet.labelStyle);
            additionalContentLabel.setAppearanceMode(0);
            this.append(additionalContentLabel);
            StringItem contentText = new StringItem(null, this.readingPlanDay.getAdditionalContent());
            this.append(contentText);
        }
        this.addCommand(COMMANDS.CMD_SHARE_SCREEN);
        if (this.readingPlanDay.hasNext()) {
            this.addCommand(COMMANDS.CMD_NEXT_DAY);
        }
        if (this.readingPlanDay.hasNext()) {
            this.addCommand(COMMANDS.CMD_PREVIOUS_DAY);
        }
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        if (this.readingPlanDay == null) {
            return Locale.get(152);
        }
        String currentDayStr = "" + this.readingPlanDay.getCurrent();
        String totalDaysStr = "" + this.readingPlanDay.getPlan().getTotalDays();
        String[] titleParams = new String[]{currentDayStr, totalDaysStr};
        return Locale.get(2, titleParams);
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_NEXT_DAY == c) {
            ReadingPlanDay nextReadingPlanDay = new ReadingPlanDay();
            nextReadingPlanDay.setPlan(this.readingPlanDay.getPlan());
            nextReadingPlanDay.setCurrent(this.readingPlanDay.getCurrent() + 1);
            EVENT_SYSTEM.queueEvent(990035, 2, nextReadingPlanDay);
        } else if (COMMANDS.CMD_PREVIOUS_DAY == c) {
            ReadingPlanDay previousReadingPlanDay = new ReadingPlanDay();
            previousReadingPlanDay.setPlan(this.readingPlanDay.getPlan());
            previousReadingPlanDay.setCurrent(this.readingPlanDay.getCurrent() - 1);
            EVENT_SYSTEM.queueEvent(990035, 2, previousReadingPlanDay);
        } else if (COMMANDS.CMD_SHARE_SCREEN == c) {
            String dayNo = Integer.toString(this.readingPlanDay.getCurrent());
            String planName = this.readingPlanDay.getPlan().getName();
            String[] params = new String[]{dayNo, planName};
            EVENT_SYSTEM.queueEvent(990011, new Object[]{Locale.get(4, params), this.readingPlanDay.getShortUrl()});
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        Integer referenceNumber = (Integer)item.getAttribute(KEY_INDEX);
        Bookmark currentBookmark = (Bookmark)OPTIONS.getOption(3);
        String version = currentBookmark.getVersion();
        EVENT_SYSTEM.queueEvent(990036, 2, new Object[]{version, referenceNumber, this.readingPlanDay});
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        if (this.readingPlanDay.hasPrev() && gameAction == 2) {
            this.handleCommand(COMMANDS.CMD_PREVIOUS_DAY);
            return true;
        }
        if (this.readingPlanDay.hasNext() && gameAction == 5) {
            this.handleCommand(COMMANDS.CMD_NEXT_DAY);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }
}

