/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.plans;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.BibleReferenceManager;
import com.youversion.application.model.ReadingPlansManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.views.core.BaseReaderForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.ReadingPlanAdjustedDayCollection;
import com.youversion.objects.ReadingPlanDay;
import com.youversion.objects.Reference;
import com.youversion.objects.VerseCollection;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.Style;
import java.util.Vector;

public class BibleReadReferenceForm
extends BaseReaderForm
implements ItemCommandListener,
CommandListener {
    private String version;
    private Reference reference;
    private VerseCollection verseCollection;
    private int referenceNumber;
    private ReadingPlanDay readingPlanDay;

    public BibleReadReferenceForm() {
        this((Style)null);
    }

    public BibleReadReferenceForm(Style style) {
        super(style);
        BibleReferenceManager bibleReferenceManager = BibleReferenceManager.getInstance();
        this.version = bibleReferenceManager.getVersion();
        this.reference = bibleReferenceManager.getReference();
        this.verseCollection = bibleReferenceManager.getVerseCollection();
        this.readingPlanDay = bibleReferenceManager.getReadingPlanDay();
        this.referenceNumber = bibleReferenceManager.getReferenceNumber();
        this.populateVerseContainer(this.verseCollection, this.container, 0);
        this.addCommand(COMMANDS.CMD_OPEN_IN_READER);
        if (this.referenceNumber > 0) {
            this.addCommand(COMMANDS.CMD_PREVIOUS_REFERENCE);
        }
        if (this.referenceNumber < this.readingPlanDay.getTotalReadings() - 1) {
            this.addCommand(COMMANDS.CMD_NEXT_REFERENCE);
        }
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        this.updateReferences();
    }

    public String getTitle() {
        return this.reference.getHumanString();
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_OPEN_IN_READER == c) {
            Bookmark bookmark = new Bookmark(this.version, this.reference);
            BookmarkChapterDescriptor bookmarkChapterDescriptor = new BookmarkChapterDescriptor(bookmark);
            EVENT_SYSTEM.queueEvent(990004, 2, bookmarkChapterDescriptor);
        } else if (COMMANDS.CMD_NEXT_REFERENCE == c) {
            Integer nextReferenceNumber = new Integer(this.referenceNumber + 1);
            EVENT_SYSTEM.queueEvent(990036, new Object[]{this.version, nextReferenceNumber, this.readingPlanDay});
            EVENT_SYSTEM.queueEvent(998882, this);
        } else if (COMMANDS.CMD_PREVIOUS_REFERENCE == c) {
            Integer previousReferenceNumber = new Integer(this.referenceNumber - 1);
            EVENT_SYSTEM.queueEvent(990036, new Object[]{this.version, previousReferenceNumber, this.readingPlanDay});
            EVENT_SYSTEM.queueEvent(998882, this);
        } else {
            super.commandAction(c, d);
        }
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        if (this.referenceNumber > 0 && gameAction == 2) {
            this.handleCommand(COMMANDS.CMD_PREVIOUS_REFERENCE);
            return true;
        }
        if (this.referenceNumber < this.readingPlanDay.getTotalReadings() - 1 && gameAction == 5) {
            this.handleCommand(COMMANDS.CMD_NEXT_REFERENCE);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }

    public void updateReferences() {
        ReadingPlanAdjustedDayCollection adjustedDayCollection = BibleReferenceManager.getInstance().getReadingPlanDay().getAdjustedDays();
        Vector referencesCompleted = adjustedDayCollection.getCompletedReferences(0);
        String selectedReference = adjustedDayCollection.getReference(this.referenceNumber).getReference().getOsis();
        adjustedDayCollection.getReference(this.referenceNumber).setCompleted(true);
        referencesCompleted.addElement(selectedReference);
        if (OPTIONS.isLoggedIn()) {
            EVENT_SYSTEM.queueEvent(200027, 2, new Object[]{new Integer(this.readingPlanDay.getPlan().getId()), new Integer(this.readingPlanDay.getCurrent()), referencesCompleted});
        }
    }

    public String getVersionStr() {
        return this.version;
    }

    public void hideNotify() {
        ReadingPlansManager.getInstance().setContext(-1);
    }
}

