/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.plans;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.ReadingPlansManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanDay;
import de.enough.polish.calendar.CalendarEntry;
import de.enough.polish.calendar.CalendarItem;
import de.enough.polish.calendar.CalendarRenderer;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import de.enough.polish.util.TimePeriod;
import de.enough.polish.util.TimePoint;
import java.util.Date;

public class BiblePlansCalendarView
extends BaseForm
implements ItemCommandListener,
CalendarRenderer {
    private static final String KEY_PAYLOAD = "obj";
    private CalendarItem calendarItem;

    public BiblePlansCalendarView() {
        this((Style)null);
    }

    public BiblePlansCalendarView(Style style) {
        super(style);
    }

    public String getTitle() {
        return Locale.get(88);
    }

    public void setContent() {
        TimePoint start;
        this.container.clear();
        this.removeAllCommands();
        ReadingPlan plan = ReadingPlansManager.getInstance().getCurrentPlan();
        CalendarItem.setMonths(Locale.get(87));
        CalendarItem.setWeekDayAbbreviations(Locale.get(89));
        this.calendarItem = new CalendarItem(new TimePoint(new Date()), StyleSheet.calendarStyle);
        this.calendarItem.setRenderer(this);
        TimePeriod validPeriod = null;
        if (plan.getSubscription() != null) {
            start = new TimePoint(plan.getSubscription().getStart());
            start.addDay(-1);
            TimePoint end = new TimePoint(plan.getSubscription().getEnd());
            validPeriod = new TimePeriod(start, end);
        } else {
            start = new TimePoint(new Date());
            start.addDay(-1);
            TimePoint end = new TimePoint(start);
            end.addDay(plan.getTotalDays() - 1);
            validPeriod = new TimePeriod(start, end);
        }
        this.calendarItem.setValidPeriod(validPeriod);
        this.calendarItem.setCalendarInactiveDaysAreInteractive(true);
        if (plan.getSubscription() != null) {
            TimePoint currentDay = new TimePoint(this.calendarItem.getValidPeriod().getStart());
            currentDay.addDay(plan.getCurrentDay());
            this.calendarItem.go(currentDay);
        }
        this.append(this.calendarItem);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public void commandAction(Command c, Item item) {
        if (this.calendarItem.isFocused() && c == COMMANDS.CMD_SELECT) {
            TimePoint selected = this.calendarItem.getSelectedTimePoint();
            TimePoint start = this.calendarItem.getValidPeriod().getStart();
            long duration = selected.getTimeInMillis() - start.getTimeInMillis();
            int daysDiff = (int)(duration / 1000L / 3600L / 24L);
            ReadingPlan plan = ReadingPlansManager.getInstance().getCurrentPlan();
            ReadingPlanDay readingPlanDay = new ReadingPlanDay();
            readingPlanDay.setPlan(plan);
            readingPlanDay.setCurrent(daysDiff);
            EVENT_SYSTEM.queueEvent(990035, readingPlanDay);
        }
    }

    public Item createCalendaryDay(TimePoint day, TimePoint currentMonth, TimePoint originalCurrentDay, CalendarEntry[] entriesForTheDay, CalendarItem parent) {
        StringItem result = null;
        TimePeriod period = parent.getValidPeriod();
        TimePoint selected = day;
        TimePoint start = this.calendarItem.getValidPeriod().getStart();
        long duration = selected.getTimeInMillis() - start.getTimeInMillis();
        int daysDiff = (int)(duration / 1000L / 3600L / 24L);
        ReadingPlan plan = ReadingPlansManager.getInstance().getCurrentPlan();
        if (!currentMonth.equalsMonth(day)) {
            result = new StringItem(null, "", 0);
        } else if (day.equals(originalCurrentDay, TimePeriod.SCOPE_DAY)) {
            result = new StringItem(null, Integer.toString(day.getDay()), 3, StyleSheet.calendarcurrentdayStyle);
            result.setDefaultCommand(COMMANDS.CMD_SELECT);
            result.setItemCommandListener(this);
        } else if (period.matches(day)) {
            result = new StringItem(null, Integer.toString(day.getDay()), 3, StyleSheet.calendardayStyle);
            result.setDefaultCommand(COMMANDS.CMD_SELECT);
            result.setItemCommandListener(this);
        } else {
            result = new StringItem(null, Integer.toString(day.getDay()), StyleSheet.calendardayinvalidStyle);
        }
        return result;
    }
}

