/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.notes;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.ViewNoteManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.Note;
import com.youversion.objects.Reference;
import com.youversion.objects.ReferenceCollection;
import com.youversion.objects.User;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class ViewNoteForm
extends BaseForm
implements ItemCommandListener {
    public static final String OBJECT = "object";

    public ViewNoteForm() {
        this((Style)null);
    }

    public ViewNoteForm(Style style) {
        super(style);
    }

    public String getTitle() {
        return Locale.get(77);
    }

    public void showNotify() {
        super.showNotify();
        this.addFormContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            ViewNoteManager manager = ViewNoteManager.getInstance();
            Note note = manager.getNote();
            Container headerList = new Container(false, StyleSheet.note_view_headerStyle);
            StringItem titleItem = new StringItem(null, note.getTitle().trim(), 0, StyleSheet.note_titleStyle);
            headerList.add(titleItem);
            StringItem date = new StringItem(null, Locale.formatDate(note.getCreated()).trim(), StyleSheet.note_modeStyle);
            headerList.add(date);
            this.append(headerList);
            StringItem noteDetails = new StringItem(null, note.getContentText(), StyleSheet.textStyle);
            noteDetails.setAppearanceMode(0);
            this.append(noteDetails);
            ReferenceCollection references = note.getReferences();
            if (references.size() > 0) {
                StringItem referencesLabel = new StringItem(null, Locale.get(96), 0, StyleSheet.labelStyle);
                this.append(referencesLabel);
                for (int i = 0; i < references.size(); ++i) {
                    Reference ref = references.elementAt(i);
                    StringItem referenceItem = new StringItem(null, ref.getHumanString(), 3, StyleSheet.list_itemStyle);
                    referenceItem.setDefaultCommand(COMMANDS.CMD_SELECT);
                    referenceItem.setItemCommandListener(this);
                    referenceItem.setAttribute(OBJECT, ref);
                    this.append(referenceItem);
                }
            }
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
            if (OPTIONS.isLoggedIn()) {
                User user = (User)((Object[])OPTIONS.getOption(1))[2];
                if (note.getUserId() == user.getId()) {
                    this.addCommand(COMMANDS.CMD_EDIT_NOTE_SCREEN);
                }
            }
        }
    }

    public void commandAction(Command c, Item item) {
        Object obj;
        if (c == COMMANDS.CMD_SELECT && (obj = item.getAttribute(OBJECT)) instanceof Reference) {
            Reference ref = (Reference)obj;
            ViewNoteManager manager = ViewNoteManager.getInstance();
            Note note = manager.getNote();
            Bookmark bookmark = new Bookmark(note.getVersion(), ref);
            BibleReaderManager.getInstance().setContext(0);
            EVENT_SYSTEM.queueEvent(100010, new BookmarkChapterDescriptor(bookmark));
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == COMMANDS.CMD_EDIT_NOTE_SCREEN) {
            ViewNoteManager manager = ViewNoteManager.getInstance();
            Note note = manager.getNote();
            EVENT_SYSTEM.queueEvent(990046, note);
        } else {
            super.commandAction(c, d);
        }
    }
}

