/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.notes;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.internal.caching.BibleChapterSource;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.EditNoteManager;
import com.youversion.application.model.reader.ChapterDescriptor;
import com.youversion.application.views.core.BaseReaderForm;
import com.youversion.internal.Chapter;
import com.youversion.objects.Book;
import com.youversion.objects.Note;
import com.youversion.objects.ReferenceCollection;
import com.youversion.objects.Verse;
import com.youversion.objects.VerseCollection;
import com.youversion.objects.Version;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Locale;

public class SelectVersesForm
extends BaseReaderForm
implements ItemCommandListener,
CommandListener {
    protected String chapterTitle;
    protected String versionTitle;
    private final ChapterDescriptor chapterDescriptor;

    public SelectVersesForm() {
        this((Style)null);
    }

    public SelectVersesForm(Style style) {
        super(style);
        BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
        this.chapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
    }

    private boolean hasPrevChapter() {
        Integer chapterNumber = this.chapterDescriptor.getChapterNumber();
        return chapterNumber > 1;
    }

    private boolean hasNextChapter() {
        Integer chapterNumber = this.chapterDescriptor.getChapterNumber();
        Book book = this.chapterDescriptor.getBook();
        return chapterNumber < book.getChapters();
    }

    public String getTitle() {
        return this.chapterTitle;
    }

    public String getTitleExtra() {
        if (this.chapterDescriptor.getChapter() == BibleChapterSource.MISSING_CHAPTER || this.chapterDescriptor.getBook() == null) {
            return "";
        }
        return this.versionTitle.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            if (this.chapterDescriptor.getChapter() == BibleChapterSource.MISSING_CHAPTER || this.chapterDescriptor.getBook() == null) {
                StringItem noContent = new StringItem(null, Locale.get(117), 0);
                this.append(noContent);
                COMMANDS.CMD_READER_CHANGE.removeSubCommands();
                this.addCommand(COMMANDS.CMD_READER_CHANGE);
                this.addSubCommand(COMMANDS.CMD_READER_CHANGE_BOOK, COMMANDS.CMD_READER_CHANGE);
                this.addSubCommand(COMMANDS.CMD_READER_CHANGE_VERSION, COMMANDS.CMD_READER_CHANGE);
                this.addSubCommand(COMMANDS.CMD_READER_CHANGE_LANGUAGE, COMMANDS.CMD_READER_CHANGE);
                this.addCommand(COMMANDS.CMD_SHOW_READER_OPTIONS);
                this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
                return;
            }
            Version version = this.chapterDescriptor.getVersion();
            Book book = this.chapterDescriptor.getBook();
            Chapter chapter = this.chapterDescriptor.getChapter();
            Integer chapterNumber = this.chapterDescriptor.getChapterNumber();
            Integer verseNumber = this.chapterDescriptor.getVerseNumber();
            if (this.hasPrevChapter()) {
                this.addCommand(COMMANDS.CMD_READER_PREVIOUS_CHAPTER);
            }
            if (this.hasNextChapter()) {
                this.addCommand(COMMANDS.CMD_READER_NEXT_CHAPTER);
            }
            VerseCollection verses = chapter.getVerses();
            this.populateVerseContainer(verses, this.container, verseNumber);
            if (verseNumber < 1 && this.container.getNumberOfInteractiveItems() > 0) {
                this.focus(0);
            }
            this.chapterTitle = book.getHuman() + " " + chapterNumber;
            this.versionTitle = " (" + version.getAbbreviation() + ")";
            COMMANDS.CMD_READER_CHANGE.removeSubCommands();
            this.addCommand(COMMANDS.CMD_READER_CHANGE);
            this.addSubCommand(COMMANDS.CMD_READER_CHANGE_BOOK, COMMANDS.CMD_READER_CHANGE);
            this.addSubCommand(COMMANDS.CMD_READER_CHANGE_VERSION, COMMANDS.CMD_READER_CHANGE);
            this.addSubCommand(COMMANDS.CMD_READER_CHANGE_LANGUAGE, COMMANDS.CMD_READER_CHANGE);
            this.addSubCommand(COMMANDS.CMD_READER_CHANGE_CHAPTER, COMMANDS.CMD_READER_CHANGE);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    public void populateVerseContainer(VerseCollection verses, Container container, int verseNoToFocus) {
        Style verseStyle = null;
        ChoiceItem toBeFocused = null;
        for (int i = 0; i < verses.size(); ++i) {
            Verse v = verses.elementAt(i);
            verseStyle = this.getStyleFor(v);
            ChoiceItem item = new ChoiceItem(v.getReference().getHumanString(), null, 2);
            item.setDefaultCommand(COMMANDS.CMD_SELECT);
            item.setItemCommandListener(this);
            item.setAttribute("obj", v);
            container.add(item);
            if (v.getReference().getStartVerse() != verseNoToFocus) continue;
            toBeFocused = item;
        }
        if (toBeFocused != null) {
            this.focus(toBeFocused);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_READER_CHANGE_BOOK == c) {
            EVENT_SYSTEM.queueEvent(990002);
        } else if (COMMANDS.CMD_READER_CHANGE_VERSION == c) {
            EVENT_SYSTEM.queueEvent(990001);
        } else if (COMMANDS.CMD_READER_CHANGE_LANGUAGE == c) {
            EVENT_SYSTEM.queueEvent(990005);
        } else if (COMMANDS.CMD_READER_CHANGE_CHAPTER == c) {
            EVENT_SYSTEM.queueEvent(990003);
        } else if (COMMANDS.CMD_READER_NEXT_CHAPTER == c) {
            this.updateReferences();
            Integer desiredChapter = new Integer(this.chapterDescriptor.getChapterNumber() + 1);
            EVENT_SYSTEM.queueEvent(990004, 2, new Object[]{desiredChapter, this.chapterDescriptor.getBook(), this.chapterDescriptor.getVersion()});
        } else if (COMMANDS.CMD_READER_PREVIOUS_CHAPTER == c) {
            this.updateReferences();
            Integer desiredChapter = new Integer(this.chapterDescriptor.getChapterNumber() - 1);
            EVENT_SYSTEM.queueEvent(990004, 2, new Object[]{desiredChapter, this.chapterDescriptor.getBook(), this.chapterDescriptor.getVersion()});
        } else if (COMMANDS.CMD_NAVIGATION_BACK == c) {
            this.updateReferences();
            super.commandAction(c, d);
        } else {
            super.commandAction(c, d);
        }
    }

    public void updateReferences() {
        ReferenceCollection references = new ReferenceCollection();
        for (int i = 0; i < this.container.size(); ++i) {
            ChoiceItem choiceItem;
            Item item = this.container.get(i);
            if (!(item instanceof ChoiceItem) || !(choiceItem = (ChoiceItem)item).isSelected()) continue;
            references.addElement(((Verse)item.getAttribute("obj")).getReference());
        }
        EditNoteManager manager = EditNoteManager.getInstance();
        Note note = manager.getNote();
        references.addAll(note.getReferences());
        manager.setTempReferences(references);
        EVENT_SYSTEM.queueEvent(5, note);
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        if (gameAction == 2 && this.hasPrevChapter()) {
            this.updateReferences();
            this.handleCommand(COMMANDS.CMD_READER_PREVIOUS_CHAPTER);
            return true;
        }
        if (gameAction == 5 && this.hasNextChapter()) {
            this.updateReferences();
            this.handleCommand(COMMANDS.CMD_READER_NEXT_CHAPTER);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }

    public void commandAction(Command c, Item item) {
        if (c == COMMANDS.CMD_SELECT && item instanceof ChoiceItem) {
            ChoiceItem choice;
            choice.select(!(choice = (ChoiceItem)item).isSelected());
        }
    }

    public String getVersionStr() {
        Version version = this.chapterDescriptor.getVersion();
        return version.getAbbreviation();
    }

    public Container getVersesContainer() {
        return this.container;
    }
}

