/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.notes;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.EditNoteManager;
import com.youversion.application.model.MyNotesManager;
import com.youversion.application.views.AlertForm;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.Note;
import com.youversion.objects.NoteCollection;
import com.youversion.polish.extensions.item.NoteItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class MyNotesForm
extends BaseForm
implements ItemCommandListener,
CommandListener {
    private Container header = new Container(StyleSheet.itemStyle);
    private Container results = new Container(StyleSheet.itemStyle);
    int lastFocusedItem = 0;

    public MyNotesForm() {
        this((Style)null);
    }

    public MyNotesForm(Style style) {
        super(style);
        this.addFormContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.header.clear();
            this.results.clear();
            this.append(this.header);
            this.append(this.results);
            MyNotesManager manager = MyNotesManager.getInstance();
            if (manager.getNoteCollection() != null) {
                this.populateResults(manager.getNoteCollection());
            } else if (this.results.size() == 0) {
                StringItem noNotes = new StringItem(null, Locale.get(68), StyleSheet.textStyle);
                this.results.add(noNotes);
            }
            this.populateMenu();
        }
    }

    public void populateMenu() {
        this.removeAllCommands();
        MyNotesManager manager = MyNotesManager.getInstance();
        NoteCollection notes = manager.getNoteCollection();
        if (notes != null) {
            int total = notes.getTotal();
            int noOfPages = (int)Math.ceil(1.0 * (double)total / 25.0);
            if (manager.getPage() > 1) {
                this.addCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            }
            if (manager.getPage() < noOfPages) {
                this.addCommand(COMMANDS.CMD_NEXT_PAGE);
            }
        }
        COMMANDS.CMD_NOTES_VIEW_TYPE.removeSubCommands();
        this.addCommand(COMMANDS.CMD_NOTES_VIEW_TYPE);
        this.addSubCommand(COMMANDS.CMD_NOTES_MY_ALL, COMMANDS.CMD_NOTES_VIEW_TYPE);
        this.addSubCommand(COMMANDS.CMD_NOTES_MY_PUBLIC, COMMANDS.CMD_NOTES_VIEW_TYPE);
        this.addSubCommand(COMMANDS.CMD_NOTES_MY_PRIVATE, COMMANDS.CMD_NOTES_VIEW_TYPE);
        this.addSubCommand(COMMANDS.CMD_NOTES_MY_DRAFT, COMMANDS.CMD_NOTES_VIEW_TYPE);
        this.addCommand(COMMANDS.CMD_ADD_NOTE_SCREEN);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public void commandAction(Command c, Displayable d) {
        MyNotesManager manager = MyNotesManager.getInstance();
        if (COMMANDS.CMD_NEXT_PAGE == c) {
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(manager.getPage() + 1), null, manager.getMode()});
        } else if (COMMANDS.CMD_PREVIOUS_PAGE == c) {
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(manager.getPage() - 1), null, manager.getMode()});
        } else if (COMMANDS.CMD_NOTES_MY_ALL == c) {
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(1), null, null});
        } else if (COMMANDS.CMD_NOTES_MY_PUBLIC == c) {
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(1), null, "public"});
        } else if (COMMANDS.CMD_NOTES_MY_PRIVATE == c) {
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(1), null, "private"});
        } else if (COMMANDS.CMD_NOTES_MY_DRAFT == c) {
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(1), null, "draft"});
        } else if (COMMANDS.CMD_ADD_NOTE_SCREEN == c) {
            Note note = new Note();
            Bookmark bookmark = (Bookmark)OPTIONS.getOption(3);
            note.setVersion(bookmark.getVersion());
            EditNoteManager.getInstance().setContext(1);
            EVENT_SYSTEM.queueEvent(990046, note);
        } else if (COMMANDS.CMD_YES == c) {
            Item item = (Item)COMMANDS.CMD_YES.getData();
            EditNoteManager.getInstance().setContext(1);
            EVENT_SYSTEM.queueEvent(200049, 1, 2, ((NoteItem)item).getNote());
        } else {
            super.commandAction(c, d);
        }
    }

    public void updateNotes(Note note) {
        int index = this.results.getFocusedIndex();
        this.addFormContent();
        this.results.focusChild(index);
    }

    public void commandAction(Command c, Item item) {
        if (c == COMMANDS.CMD_SELECT) {
            if (item instanceof NoteItem) {
                EVENT_SYSTEM.queueEvent(990043, ((NoteItem)item).getNote());
            }
        } else if (c == COMMANDS.CMD_EDIT_NOTE) {
            EditNoteManager.getInstance().setContext(1);
            EVENT_SYSTEM.queueEvent(990046, ((NoteItem)item).getNote());
        } else if (c == COMMANDS.CMD_DELETE_NOTE) {
            AlertForm.showQuestionDialog(Locale.get(142), Locale.get(134), this, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateResults(NoteCollection results) {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.results.clear();
            for (int i = 0; i < results.size(); ++i) {
                NoteItem item = new NoteItem((Note)results.elementAt(i));
                item.setDefaultCommand(COMMANDS.CMD_SELECT);
                item.addCommand(COMMANDS.CMD_EDIT_NOTE);
                item.addCommand(COMMANDS.CMD_DELETE_NOTE);
                item.setItemCommandListener(this);
                this.results.add(item);
            }
            if (this.results.size() == 0) {
                StringItem noNotes = new StringItem(null, Locale.get(68), 0, StyleSheet.textStyle);
                this.results.add(noNotes);
            }
        }
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        MyNotesManager manager = MyNotesManager.getInstance();
        if (manager.getNoteCollection() == null) {
            return super.handleKeyReleased(keycode, gameAction);
        }
        int total = manager.getNoteCollection().getTotal();
        int noOfPages = (int)Math.ceil(1.0 * (double)total / 25.0);
        if (manager.getPage() > 1 && gameAction == 2) {
            this.handleCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            return true;
        }
        if (manager.getPage() < noOfPages && gameAction == 5) {
            this.handleCommand(COMMANDS.CMD_NEXT_PAGE);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }

    public String getTitle() {
        MyNotesManager manager = MyNotesManager.getInstance();
        if (manager.getMode() == null) {
            return Locale.get(71);
        }
        if (manager.getMode().equals("private")) {
            return Locale.get(73);
        }
        if (manager.getMode().equals("public")) {
            return Locale.get(74);
        }
        if (manager.getMode().equals("draft")) {
            return Locale.get(72);
        }
        return Locale.get(71);
    }
}

