/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.bookmarks;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.BookmarksManager;
import com.youversion.application.views.AlertForm;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Bookmark;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.Locale;

public class EditBookmarkForm
extends BaseForm
implements ItemCommandListener,
ItemStateListener {
    TextField bookmarkTitle;
    TextField bookmarkLabels;
    StringItem saveBookmark;
    boolean hasChanged = false;

    public EditBookmarkForm() {
        this((Style)null);
    }

    public EditBookmarkForm(Style style) {
        super(style);
    }

    public String getTitle() {
        BookmarksManager manager = BookmarksManager.getInstance();
        Bookmark bookmark = manager.getWorkingBookmark();
        if (bookmark.getId() > 0L) {
            return Locale.get(212);
        }
        return Locale.get(211);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            BookmarksManager manager = BookmarksManager.getInstance();
            Bookmark bookmark = manager.getWorkingBookmark();
            Container itemContainer = new Container(false, StyleSheet.itemStyle);
            this.bookmarkTitle = new TextField(Locale.get(210), bookmark.getTitle(), 9999, 0, StyleSheet.textfieldStyle);
            this.bookmarkTitle.setItemStateListener(this);
            itemContainer.add(this.bookmarkTitle);
            this.bookmarkLabels = new TextField(Locale.get(217), bookmark.getLabels(), 9999, 0, StyleSheet.textfieldStyle);
            this.bookmarkLabels.setItemStateListener(this);
            itemContainer.add(this.bookmarkLabels);
            this.saveBookmark = new StringItem(null, Locale.get(218), 3, StyleSheet.buttonStyle);
            this.saveBookmark.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.saveBookmark.setItemCommandListener(this);
            itemContainer.add(this.saveBookmark);
            this.append(itemContainer);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    public void commandAction(Command c, Item item) {
        BookmarksManager manager = BookmarksManager.getInstance();
        Bookmark bookmark = manager.getWorkingBookmark();
        if (item == this.saveBookmark) {
            String title = this.bookmarkTitle.getString();
            if (title == null) {
                title = "";
            }
            bookmark.setTitle(title);
            String label = this.bookmarkLabels.getString();
            bookmark.setLabels(label);
            EVENT_SYSTEM.queueEvent(100012, bookmark);
            EVENT_SYSTEM.queueEvent(998882, this);
        }
    }

    public void commandAction(Command c, Displayable d) {
        BookmarksManager manager = BookmarksManager.getInstance();
        Bookmark bookmark = manager.getWorkingBookmark();
        if (COMMANDS.CMD_NAVIGATION_BACK == c && bookmark.getId() > 0L) {
            if (this.getChanged()) {
                AlertForm.showQuestionDialog(Locale.get(142), Locale.get(135), this, null);
            } else {
                super.commandAction(c, d);
            }
        } else if (COMMANDS.CMD_YES == c) {
            super.commandAction(COMMANDS.CMD_NAVIGATION_BACK, d);
        } else {
            super.commandAction(c, d);
        }
    }

    public void setChanged(boolean value) {
        this.hasChanged = value;
    }

    public boolean getChanged() {
        return this.hasChanged;
    }

    public void itemStateChanged(Item item) {
        this.setChanged(true);
    }
}

