/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.bookmarks;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.BookmarksManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.BookmarkLabel;
import com.youversion.objects.BookmarkLabelCollection;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class BookmarksLabelsForm
extends BaseForm
implements ItemCommandListener {
    protected static final String KEY_LABEL = "obj";
    private BookmarkLabelCollection bookmarksLabels;
    private int page;
    private Container loadingContainer = new Container(false, StyleSheet.splash_screenStyle);
    private Gauge loadingGauge = new Gauge(null, false, -1, 2, StyleSheet.loading_gaugeStyle);

    public BookmarksLabelsForm() {
        this((Style)null);
    }

    public BookmarksLabelsForm(Style style) {
        super(style);
        this.loadingContainer.add(this.loadingGauge);
    }

    public String getTitle() {
        return Locale.get(222);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoading() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            this.append(this.loadingContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            BookmarksManager bookmarksManager = BookmarksManager.getInstance();
            this.bookmarksLabels = bookmarksManager.getBookmarkLabelCollection();
            this.page = bookmarksManager.getBookmarksLabelsPage();
            if (this.bookmarksLabels != null && this.bookmarksLabels.size() > 0) {
                for (int index = 0; index < this.bookmarksLabels.size(); ++index) {
                    BookmarkLabel label = this.bookmarksLabels.elementAt(index);
                    StringItem bookmarkItem = new StringItem(null, label.getLabel() + " (" + label.getTotal() + ")", 3, StyleSheet.list_itemStyle);
                    bookmarkItem.setAttribute(KEY_LABEL, label);
                    bookmarkItem.setDefaultCommand(COMMANDS.CMD_SELECT);
                    bookmarkItem.setItemCommandListener(this);
                    this.container.add(bookmarkItem);
                }
                int total = this.bookmarksLabels.getTotal();
                int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
                if (this.page > 1) {
                    this.addCommand(COMMANDS.CMD_PREVIOUS_PAGE);
                }
                if (this.page < pages) {
                    this.addCommand(COMMANDS.CMD_NEXT_PAGE);
                }
            } else {
                StringItem noBookmarks = new StringItem(null, Locale.get(220), 0, StyleSheet.textStyle);
                this.container.add(noBookmarks);
            }
            this.addCommand(COMMANDS.CMD_BOOKMARKS_RETURN_TO_BOOKMARKS);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_NEXT_PAGE == c) {
            EVENT_SYSTEM.queueEvent(100015, new Integer(this.page + 1));
        } else if (COMMANDS.CMD_PREVIOUS_PAGE == c) {
            EVENT_SYSTEM.queueEvent(100015, new Integer(this.page - 1));
        } else if (COMMANDS.CMD_BOOKMARKS_RETURN_TO_BOOKMARKS == c) {
            EVENT_SYSTEM.queueEvent(998882, this);
            EVENT_SYSTEM.queueEvent(990010);
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            BookmarkLabel label = (BookmarkLabel)item.getAttribute(KEY_LABEL);
            EVENT_SYSTEM.queueEvent(100017, 2, label);
            EVENT_SYSTEM.queueEvent(998882, this);
            EVENT_SYSTEM.queueEvent(100008, 2, new Integer(1));
        }
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        if (this.bookmarksLabels == null) {
            return false;
        }
        int total = this.bookmarksLabels.getTotal();
        int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
        if (this.page > 1 && gameAction == 2) {
            this.handleCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            return true;
        }
        if (this.page < pages && gameAction == 5) {
            this.handleCommand(COMMANDS.CMD_NEXT_PAGE);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }
}

