/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.User;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.Locale;
import java.util.Vector;

public class ShareForm
extends BaseForm
implements ItemCommandListener {
    private TextField contentField;
    private TextField linkField;
    private StringItem shareItem;
    private ChoiceGroup connectionsGroup;
    private ChoiceItem facebookItem = new ChoiceItem("Facebook", null, 2, StyleSheet.checkboxStyle);
    private ChoiceItem twitterItem = new ChoiceItem("Twitter", null, 2, StyleSheet.checkboxStyle);

    public ShareForm(String text, String link) {
        this(text, link, null);
    }

    public ShareForm(String text, String link, Style style) {
        super(style);
        int activeConnections = 2;
        User loggedInUser = OPTIONS.getUser();
        if (loggedInUser.getFacebook() == null) {
            this.facebookItem.setAppearanceMode(0);
            this.facebookItem.setStyle(StyleSheet.checkbox_disabledStyle);
            --activeConnections;
        }
        if (loggedInUser.getTwitter() == null) {
            this.twitterItem.setAppearanceMode(0);
            this.twitterItem.setStyle(StyleSheet.checkbox_disabledStyle);
            --activeConnections;
        }
        this.contentField = new TextField(Locale.get(129), text, 9999, 0, StyleSheet.textfieldStyle);
        this.linkField = new TextField(Locale.get(130), link, 999, 0, StyleSheet.textfieldStyle);
        this.connectionsGroup = new ChoiceGroup(Locale.get(128), 2, StyleSheet.itemStyle);
        this.connectionsGroup.add(this.facebookItem);
        this.connectionsGroup.add(this.twitterItem);
        this.shareItem = new StringItem(null, Locale.get(131), 3, StyleSheet.buttonStyle);
        this.shareItem.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.shareItem.setItemCommandListener(this);
        this.append(this.contentField);
        this.append(this.linkField);
        this.append(this.connectionsGroup);
        if (activeConnections == 0) {
            this.shareItem.setStyle(StyleSheet.button_disabledStyle);
            this.shareItem.setAppearanceMode(0);
        }
        this.append(this.shareItem);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(132);
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c && item == this.shareItem) {
            Vector<String> connections = new Vector<String>();
            User loggedInUser = OPTIONS.getUser();
            if (loggedInUser.getFacebook() != null) {
                connections.addElement("facebook");
            }
            if (loggedInUser.getTwitter() != null) {
                connections.addElement("twitter");
            }
            EVENT_SYSTEM.queueEvent(200013, 2, new Object[]{this.contentField.getText(), this.linkField.getText(), connections});
            EVENT_SYSTEM.queueEvent(998881);
        }
    }
}

