/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.User;
import com.youversion.utils.StyleHelper;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.Locale;

public class LoginForm
extends BaseForm
implements ItemCommandListener,
ItemStateListener {
    protected static final String OBJECT = "obj";
    TextField usernameField;
    TextField passwordField;
    StringItem login;

    public LoginForm() {
        this((Style)null);
    }

    public LoginForm(Style style) {
        super(style);
        String username = null;
        if (OPTIONS.isLoggedIn()) {
            User user = OPTIONS.getUser();
            username = user.getUsername();
        }
        this.usernameField = new TextField(Locale.get(46), username, 128, 0, StyleSheet.textfieldStyle);
        this.usernameField.setItemStateListener(this);
        this.passwordField = new TextField(Locale.get(44), null, 128, 65536, StyleSheet.textfieldStyle);
        this.passwordField.setItemStateListener(this);
        this.login = new StringItem(null, Locale.get(42), 3, StyleSheet.buttonStyle);
        this.login.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.login.setItemCommandListener(this);
        this.append(this.usernameField);
        this.append(this.passwordField);
        this.append(this.login);
        this.setLoginState();
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(45);
    }

    protected void setLoginState() {
        if (this.usernameField.getString().length() == 0 || this.passwordField.getString().length() == 0) {
            Style disabledStyle = StyleHelper.getStyle(StyleSheet.button_disabledStyle);
            this.login.setStyle(disabledStyle);
            this.login.setAppearanceMode(0);
        } else {
            Style disabledStyle = StyleHelper.getStyle(StyleSheet.buttonStyle);
            this.login.setStyle(disabledStyle);
            this.login.setAppearanceMode(3);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_LOGIN_SKIP == c) {
            OPTIONS.setOption(2, Boolean.FALSE);
            EVENT_SYSTEM.queueEvent(998882, this);
            EVENT_SYSTEM.queueEvent(990006);
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c && item == this.login) {
            EVENT_SYSTEM.queueEvent(200007, 2, new Object[]{this.usernameField.getString(), this.passwordField.getString()});
        }
    }

    public void itemStateChanged(Item item) {
        this.setLoginState();
    }
}

