/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.events.core;

import com.youversion.application.events.core.Event;
import com.youversion.application.events.core.EventController;
import java.util.Enumeration;
import java.util.Vector;

public class EventControllerManager
implements Runnable {
    Vector eventControllers = new Vector(1, 2);
    boolean shouldRun = true;
    Thread thread = new Thread(this);

    public EventControllerManager() {
        this.thread.start();
    }

    public void stop() {
        this.shouldRun = false;
        this.notifyAll();
    }

    public void addEventController(EventController controller) {
        this.eventControllers.addElement(controller);
        if (controller.getManager() != this) {
            controller.setManager(this);
        }
    }

    public void removeEventController(EventController controller) {
        this.eventControllers.removeElement(controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.shouldRun) {
            boolean hasMoreEvents = true;
            while (hasMoreEvents) {
                Enumeration controllers = this.eventControllers.elements();
                hasMoreEvents = false;
                while (controllers.hasMoreElements()) {
                    EventController tempController = (EventController)controllers.nextElement();
                    Event tempEvent = tempController.getNextEvent();
                    if (tempEvent == null) continue;
                    tempController.getEventListenerList().processEvent(tempEvent);
                    tempController.removeEvent(tempEvent);
                    if (tempController.getEventCount() <= 0) continue;
                    hasMoreEvents = true;
                }
            }
            EventControllerManager eventControllerManager = this;
            synchronized (eventControllerManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

