/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.navigation;

import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.ReadingPlansManager;
import com.youversion.application.views.plans.BiblePlansAllPlansForm;
import com.youversion.application.views.plans.BiblePlansCalendarView;
import com.youversion.application.views.plans.BiblePlansMyPlansForm;
import com.youversion.application.views.plans.BibleReadReferenceForm;
import com.youversion.application.views.plans.BibleReadingPlanDayForm;
import com.youversion.application.views.plans.BibleReadingPlanForm;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanDay;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class ReadingPlansController
extends NavigationController {
    private BiblePlansAllPlansForm allPlansForm;
    private BiblePlansMyPlansForm myPlansForm;
    private BibleReadingPlanForm readingPlanForm;
    private BibleReadingPlanDayForm readingPlanDayForm;

    public void processEvent(Event event) {
        try {
            Object[] payload = event.getPayload();
            switch (event.getType()) {
                case 990012: {
                    if (payload == null) {
                        payload = new Object[]{null, new Integer(1)};
                    }
                    if (this.allPlansForm == null) {
                        this.allPlansForm = new BiblePlansAllPlansForm(StyleSheet.base_screenStyle);
                    }
                    ReadingPlansController.showLoading();
                    EVENT_SYSTEM.queueEvent(200014, 2, payload);
                    break;
                }
                case 990038: {
                    if (((Object[])OPTIONS.getOption(1))[2] == null) {
                        Event loginEvent = new Event(990008, event);
                        EVENT_SYSTEM.queueEvent(990014, new Object[]{Locale.get(142), Locale.get(150), loginEvent});
                        break;
                    }
                    if (this.myPlansForm == null) {
                        this.myPlansForm = new BiblePlansMyPlansForm(StyleSheet.base_screenStyle);
                    }
                    this.myPlansForm.setLoading();
                    ReadingPlansController.showDisplayable(this.myPlansForm);
                    EVENT_SYSTEM.queueEvent(200020, 2, new Integer(1));
                    break;
                }
                case 990013: {
                    EVENT_SYSTEM.queueEvent(200022, 2, event.getPayload());
                    break;
                }
                case 990035: {
                    if (this.readingPlanDayForm == null) {
                        this.readingPlanDayForm = new BibleReadingPlanDayForm(StyleSheet.base_screenStyle);
                    }
                    ReadingPlansController.showLoading();
                    ReadingPlanDay readingPlanDay = (ReadingPlanDay)payload;
                    EVENT_SYSTEM.queueEvent(200016, 2, new Object[]{readingPlanDay.getPlan(), new Integer(readingPlanDay.getCurrent())});
                    break;
                }
                case 990036: {
                    EVENT_SYSTEM.queueEvent(200018, 2, payload);
                    break;
                }
                case 200024: 
                case 200025: 
                case 200026: {
                    ReadingPlansController.showLoading();
                    Integer page = ReadingPlansManager.getInstance().getMyPlansDescriptor().getPage();
                    EVENT_SYSTEM.queueEvent(200020, 2, page);
                    break;
                }
                case 200014: {
                    ReadingPlansController.showLoading();
                    break;
                }
                case 200020: {
                    ReadingPlansController.showLoading();
                    break;
                }
                case 200018: 
                case 200022: {
                    ReadingPlansController.showLoading();
                    break;
                }
                case 200015: {
                    this.allPlansForm.setContent();
                    ReadingPlansController.hideLoading();
                    ReadingPlansController.showDisplayable(this.allPlansForm);
                    break;
                }
                case 200021: {
                    this.myPlansForm.setContent();
                    ReadingPlansController.hideLoading();
                    ReadingPlansController.showDisplayable(this.myPlansForm);
                    break;
                }
                case 200023: {
                    if (this.readingPlanForm == null) {
                        this.readingPlanForm = new BibleReadingPlanForm(StyleSheet.base_screenStyle);
                    }
                    ReadingPlan readingPlan = (ReadingPlan)payload;
                    this.readingPlanForm.setContent(readingPlan);
                    ReadingPlansController.hideLoading();
                    ReadingPlansController.showDisplayable(this.readingPlanForm);
                    break;
                }
                case 200017: {
                    this.readingPlanDayForm.setContent();
                    ReadingPlansController.hideLoading();
                    if (ReadingPlansManager.getInstance().getContext() != -1) break;
                    ReadingPlansController.showDisplayable(this.readingPlanDayForm);
                    break;
                }
                case 200019: {
                    ReadingPlansController.hideLoading();
                    ReadingPlansManager.getInstance().setContext(4);
                    BibleReadReferenceForm readReferenceForm = new BibleReadReferenceForm(StyleSheet.reader_screenStyle);
                    ReadingPlansController.showDisplayable(readReferenceForm);
                    break;
                }
                case 990052: {
                    this.handleShowReadingPlanCalendarView(event);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleShowReadingPlanCalendarView(Event event) {
        ReadingPlan plan = (ReadingPlan)event.getPayload();
        ReadingPlansManager.getInstance().setCurrentPlan(plan);
        BiblePlansCalendarView calendarView = new BiblePlansCalendarView(StyleSheet.base_screenStyle);
        calendarView.setContent();
        ReadingPlansController.showDisplayable(calendarView);
    }

    public void release() {
        this.allPlansForm = null;
        this.myPlansForm = null;
        this.readingPlanDayForm = null;
        this.readingPlanForm = null;
    }
}

