/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.navigation;

import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.views.core.Notification;
import com.youversion.application.views.live.LiveEventForm;
import com.youversion.application.views.live.LiveEventItemForm;
import com.youversion.application.views.live.LiveEventPollResultForm;
import com.youversion.application.views.live.LiveEventSearchForm;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class LiveController
extends NavigationController {
    private LiveEventSearchForm liveSearchForm;

    public void processEvent(Event event) {
        Object payload = event.getPayload();
        switch (event.getType()) {
            case 990047: {
                if (this.liveSearchForm == null) {
                    this.liveSearchForm = new LiveEventSearchForm(StyleSheet.base_screenStyle);
                }
                this.liveSearchForm.setContent();
                LiveController.showDisplayable(this.liveSearchForm);
                break;
            }
            case 200034: {
                LiveController.showLoading();
                break;
            }
            case 200035: {
                this.liveSearchForm.setContent();
                LiveController.hideLoading();
                LiveController.showDisplayable(this.liveSearchForm);
                break;
            }
            case 990048: {
                LiveController.showLoading();
                EVENT_SYSTEM.queueEvent(200036, 2, payload);
                break;
            }
            case 200037: {
                LiveController.hideLoading();
                LiveEventForm liveEventForm = new LiveEventForm(StyleSheet.base_screenStyle);
                LiveController.showDisplayable(liveEventForm);
                break;
            }
            case 990049: {
                LiveEventItemForm liveEventItemForm = new LiveEventItemForm(StyleSheet.base_screenStyle);
                LiveController.showDisplayable(liveEventItemForm);
                break;
            }
            case 200038: 
            case 200040: 
            case 200042: {
                LiveController.showLoading();
                break;
            }
            case 200039: {
                String message = Locale.get(34);
                LiveController.hideLoading();
                Notification.show(message, this.liveSearchForm);
                break;
            }
            case 200041: {
                String message = Locale.get(38);
                LiveController.hideLoading();
                Notification.show(message, this.liveSearchForm);
                break;
            }
            case 200043: {
                LiveController.hideLoading();
                String message = Locale.get(38);
                LiveEventPollResultForm eventPollResultForm = new LiveEventPollResultForm(StyleSheet.base_screenStyle);
                LiveController.showDisplayable(eventPollResultForm);
                Notification.show(message, eventPollResultForm);
            }
        }
    }

    public void release() {
        this.liveSearchForm = null;
    }
}

