/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.navigation;

import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.BookmarksManager;
import com.youversion.application.views.bookmarks.BookmarksForm;
import com.youversion.application.views.bookmarks.BookmarksLabelsForm;
import com.youversion.application.views.bookmarks.EditBookmarkForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.BookmarkLabel;
import de.enough.polish.ui.StyleSheet;

public class BookmarksController
extends NavigationController {
    private BookmarksForm bookmarksForm;
    private BookmarksLabelsForm bookmarksLabelsForm;

    public void processEvent(Event event) {
        switch (event.getType()) {
            case 990010: {
                if (this.bookmarksForm == null) {
                    this.bookmarksForm = new BookmarksForm(StyleSheet.base_screenStyle);
                }
                BibleReaderManager.getInstance().setContext(5);
                BookmarksController.showLoading();
                EVENT_SYSTEM.queueEvent(100008, 2, new Integer(1));
                break;
            }
            case 99056: {
                if (this.bookmarksLabelsForm == null) {
                    this.bookmarksLabelsForm = new BookmarksLabelsForm(StyleSheet.base_screenStyle);
                }
                BibleReaderManager.getInstance().setContext(5);
                BookmarksController.showLoading();
                EVENT_SYSTEM.queueEvent(100015, 2, new Integer(1));
                break;
            }
            case 99055: {
                BookmarksManager.getInstance().setWorkingBookmark((Bookmark)event.getPayload());
                EditBookmarkForm editBookmarksForm = new EditBookmarkForm(StyleSheet.base_screenStyle);
                editBookmarksForm.addFormContent();
                BookmarksController.showDisplayable(editBookmarksForm);
                break;
            }
            case 100011: 
            case 100012: {
                BookmarksController.showLoading();
                Integer page = BookmarksManager.getInstance().getPage();
                EVENT_SYSTEM.queueEvent(100008, 2, page);
                break;
            }
            case 100008: {
                if (this.bookmarksForm == null) break;
                BookmarksController.showLoading();
                break;
            }
            case 100009: {
                if (this.bookmarksForm != null) {
                    this.bookmarksForm.setContent();
                }
                BookmarksController.hideLoading();
                if (this.bookmarksForm == null || BibleReaderManager.getInstance().getContext() != 5) break;
                BookmarksController.showDisplayable(this.bookmarksForm);
                break;
            }
            case 100015: {
                BookmarksController.showLoading();
                break;
            }
            case 100016: {
                if (this.bookmarksLabelsForm != null) {
                    this.bookmarksLabelsForm.setContent();
                }
                BookmarksController.hideLoading();
                if (this.bookmarksLabelsForm == null || BibleReaderManager.getInstance().getContext() != 5) break;
                BookmarksController.showDisplayable(this.bookmarksLabelsForm);
                break;
            }
            case 100017: {
                BookmarksManager.getInstance().setCurrentLabelFilter((BookmarkLabel)event.getPayload());
            }
        }
    }

    public void release() {
        this.bookmarksForm = null;
    }
}

