/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.apiextension.networking;

import com.youversion.ApiConnection;
import de.enough.polish.util.StreamUtil;
import de.enough.polish.util.base64.Base64;
import de.enough.polish.util.zip.GZipInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class YVConnection
implements ApiConnection {
    public static final String REFERER = "http://api.youversion.com";
    public static final int SECOND_IN_MILLIS = 1000;
    public static final int CONNECT_TIMEOUT = 20000;
    public static final int READ_TIMEOUT = 20000;
    public static final String CONTENT_TYPE_URLENCODED = "application/x-www-form-urlencoded";
    private static YVConnection _instance = null;

    public static final YVConnection getInstance() {
        if (_instance == null) {
            _instance = new YVConnection();
        }
        return _instance;
    }

    public ApiConnection.ApiResponse makeGetRequest(String url) throws IOException {
        return this.makeGetRequest(url, null, null);
    }

    public ApiConnection.ApiResponse makePostRequest(String url, byte[] postData) throws IOException {
        return this.makePostRequest(url, postData, null, null);
    }

    public ApiConnection.ApiResponse makeGetRequest(String url, String username, String password) throws IOException {
        this.verifyConnection();
        HttpConnection conn = (HttpConnection)Connector.open(url);
        conn.setRequestMethod("GET");
        this.addAuthHeader(conn, username, password);
        conn.setRequestProperty("Referer", REFERER);
        conn.setRequestProperty("Accept-Encoding", "gzip");
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Referer", REFERER);
        headers.put("Accept-Encoding", "gzip");
        int code = conn.getResponseCode();
        String message = conn.getResponseMessage();
        InputStream is = null;
        try {
            is = conn.openInputStream();
        }
        catch (Exception ex) {
            return new ApiConnection.ApiResponse(headers, code, message, "{\"response\":{\"code\":" + code + ",\"data\":\"\"}}");
        }
        String contentEncoding = conn.getEncoding();
        if (contentEncoding != null && contentEncoding.equals("gzip")) {
            is = new GZipInputStream(is, 1, false);
        }
        String data = StreamUtil.getString(is);
        return new ApiConnection.ApiResponse(headers, code, message, data);
    }

    public ApiConnection.ApiResponse makePostRequest(String url, byte[] postData, String username, String password) throws IOException {
        this.verifyConnection();
        HttpConnection connection = (HttpConnection)Connector.open(url);
        connection.setRequestMethod("POST");
        this.addAuthHeader(connection, username, password);
        connection.setRequestProperty("Referer", REFERER);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.setRequestProperty("Content-Type", CONTENT_TYPE_URLENCODED);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Referer", REFERER);
        headers.put("Accept-Encoding", "gzip");
        headers.put("Content-Type", CONTENT_TYPE_URLENCODED);
        OutputStream ost = connection.openOutputStream();
        ost.write(postData);
        ost.close();
        int code = connection.getResponseCode();
        String message = connection.getResponseMessage();
        InputStream inputStream = connection.openInputStream();
        String contentEncoding = connection.getEncoding();
        if (contentEncoding != null && contentEncoding.equals("gzip")) {
            inputStream = new GZipInputStream(inputStream, 1, false);
        }
        String content = StreamUtil.getString(inputStream);
        inputStream.close();
        connection.close();
        return new ApiConnection.ApiResponse(headers, code, message, content);
    }

    private void addAuthHeader(HttpConnection conn, String username, String password) throws IOException {
        if (username != null && password != null) {
            conn.setRequestProperty("Authorization", "Basic " + Base64.encode(username + ":" + password));
        }
    }

    private void verifyConnection() throws IOException {
    }
}

