/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.User;
import com.youversion.objects.UserDevice;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONObject;

public class UsersApi
extends ApiBase {
    public static final String CONNECTION_TWITTER = "twitter";
    public static final String CONNECTION_FACEBOOK = "facebook";

    public static User authenticate(ApiConnection conn, String username, String password) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/users/authenticate.json";
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return User.unloadJSON(data);
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static void share(ApiConnection conn, String username, String password, final String message, final String link, final Vector connections) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (message != null) {
                    this.put("message", message);
                }
                if (link != null) {
                    this.put("link", link);
                }
                if (connections != null) {
                    this.put("connections", ApiBase.makePlusSeparatedString(connections));
                }
            }
        };
        String url = ApiBase.URL_BASE + "/users/share.json";
        try {
            byte[] data = UsersApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                return;
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static UserDevice addDevice(ApiConnection conn, String username, String password, String vendor, String model, String os, String deviceId, String notes, String carrier) throws YouVersionApiException {
        return UsersApi.updateDevice(conn, username, password, null, vendor, model, os, deviceId, notes, carrier);
    }

    public static UserDevice updateDevice(ApiConnection conn, String username, String password, final Integer id, final String vendor, final String model, final String os, final String deviceId, final String notes, final String carrier) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (id != null) {
                    this.put("id", id);
                }
                if (vendor != null) {
                    this.put("vendor", vendor);
                }
                if (model != null) {
                    this.put("model", model);
                }
                if (os != null) {
                    this.put("os", os);
                }
                if (deviceId != null) {
                    this.put("device_id", deviceId);
                }
                if (notes != null) {
                    this.put("notes", notes);
                }
                if (carrier != null) {
                    this.put("carrier", carrier);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/users/set_device.json";
        try {
            byte[] data = UsersApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                return UserDevice.unloadJSON(parsed.getJSONObject("data"));
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static void deleteDevice(ApiConnection conn, String username, String password, final String id) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (id != null) {
                    this.put("id", id);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/users/delete_device.json";
        try {
            byte[] data = UsersApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                return;
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static void addVersionOffline(ApiConnection conn, String username, String password, final String version) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (version != null) {
                    this.put("version", version);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/users/add_version_offline.json";
        try {
            byte[] data = UsersApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                return;
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static Vector getVersionsOffline(ApiConnection conn, String username, String password, final Integer userId) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (userId != null) {
                    this.put("user_id", userId);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/users/versions_offline.json";
        url = url + UsersApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                Vector<String> versions = new Vector<String>();
                JSONArray array = parsed.getJSONArray("data");
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject obj = array.getJSONObject(i);
                    versions.addElement(obj.getString("version").toLowerCase());
                }
                return versions;
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static int[] allReadingPlans(ApiConnection conn, String username, String password, final Integer userId) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (userId != null) {
                    this.put("user_id", userId);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/users/all_reading_plans.json";
        url = url + UsersApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                JSONArray array = parsed.getJSONArray("data");
                int length = array.length();
                int[] list = new int[length];
                for (int i = 0; i < length; ++i) {
                    list[i] = array.getInt(i);
                }
                return list;
            }
            if (code == 404) {
                return new int[0];
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static void resendConfirmation(ApiConnection conn, final String email) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/users/resend_confirmation.json";
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (email != null) {
                    this.put("email", email);
                }
            }
        };
        try {
            byte[] data = UsersApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                return;
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static void forgotPassword(ApiConnection conn, final String email) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/users/forgot_password.json";
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (email != null) {
                    this.put("email", email);
                }
            }
        };
        try {
            byte[] data = UsersApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (UsersApi.isSuccess(code)) {
                return;
            }
            innerEx = UsersApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }
}

