/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanCalendar;
import com.youversion.objects.ReadingPlanCollection;
import com.youversion.objects.ReadingPlanDay;
import com.youversion.objects.ReadingPlanSubscription;
import com.youversion.util.JsonHelper;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONObject;

public class ReadingPlanApi
extends ApiBase {
    public static ReadingPlanCollection items(ApiConnection conn, Integer userId, int page) throws YouVersionApiException {
        return ReadingPlanApi.items(conn, null, null, userId, page);
    }

    public static ReadingPlanCollection items(ApiConnection conn, String username, String password, final Integer userId, final int page) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (userId != null) {
                    this.put("user_id", userId.toString());
                }
                this.put("page", String.valueOf(page));
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/items.json" + ReadingPlanApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return ReadingPlanCollection.unloadJSON(data);
            }
            if (code == 404) {
                return ApiBase.getApiFactory().newReadingPlanCollection();
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static ReadingPlanCollection library(ApiConnection conn, String category, int page) throws YouVersionApiException {
        return ReadingPlanApi.library(conn, category, null, page);
    }

    public static ReadingPlanCollection library(ApiConnection conn, final String category, final String lang, final int page) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (category != null) {
                    this.put("category", category);
                }
                if (lang != null) {
                    this.put("language_tag", lang);
                }
                this.put("page", String.valueOf(page));
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/library.json" + ReadingPlanApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                JSONObject obj = parsed.getJSONObject("data");
                return ReadingPlanCollection.unloadJSON(obj);
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static ReadingPlan view(ApiConnection conn, String username, String password, final Integer userId, final Integer id, final String slug) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (id != null) {
                    this.put("id", id.toString());
                }
                if (userId != null) {
                    this.put("user_id", userId.toString());
                }
                if (slug != null) {
                    this.put("slug", slug);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/view.json" + ReadingPlanApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                JSONObject obj = parsed.getJSONObject("data");
                return ReadingPlan.unloadJSON(obj);
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static ReadingPlanSubscription subscribe(ApiConnection conn, String username, String password, final Integer readingPlanId) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (readingPlanId != null) {
                    this.put("id", readingPlanId.toString());
                }
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/subscribe_user.json";
        try {
            byte[] data = ReadingPlanApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                JSONObject obj = parsed.getJSONObject("data");
                return ReadingPlanSubscription.unloadJSON(obj);
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static boolean unsubscribe(ApiConnection conn, String username, String password, final Integer readingPlanId) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (readingPlanId != null) {
                    this.put("id", readingPlanId.toString());
                }
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/unsubscribe_user.json";
        try {
            byte[] data = ReadingPlanApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                return true;
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static ReadingPlanDay references(ApiConnection conn, String username, String password, final Integer userId, final Integer readingPlanId, final Integer day) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (readingPlanId != null) {
                    this.put("id", readingPlanId);
                }
                if (userId != null) {
                    this.put("user_id", userId);
                }
                if (day != null) {
                    this.put("day", day);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/references.json" + ReadingPlanApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                JSONObject obj = parsed.getJSONObject("data");
                ReadingPlanDay output = ReadingPlanDay.unloadJSON(obj);
                if (day != null) {
                    output.setCurrent(day);
                }
                return output;
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static boolean updateCompletions(ApiConnection conn, String username, String password, final Integer readingPlanId, final Integer day, final Vector completedReferences) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (readingPlanId != null) {
                    this.put("id", readingPlanId.toString());
                }
                if (day != null) {
                    this.put("day", day.toString());
                }
                if (completedReferences != null) {
                    this.put("references", ApiBase.makePlusSeparatedString(completedReferences));
                }
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/update_completion.json";
        try {
            byte[] data = ReadingPlanApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                return true;
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static ReadingPlanCalendar calendar(ApiConnection conn, String username, String password, final Integer userId, final Integer planId) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (planId != null) {
                    this.put("id", planId);
                }
                if (userId != null) {
                    this.put("user_id", userId.toString());
                }
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/calendar.json" + ReadingPlanApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                JSONArray obj = parsed.getJSONArray("data");
                ReadingPlanCalendar calendar = ReadingPlanCalendar.unloadJSON(obj);
                calendar.setPlanId(planId);
                return calendar;
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static ReadingPlanSubscription resetSubscription(ApiConnection conn, String username, String password, final Integer planId) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("id", planId);
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/reset_subscription.json";
        try {
            byte[] data = ReadingPlanApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                JSONObject obj = parsed.getJSONObject("data");
                ReadingPlanSubscription result = ReadingPlanSubscription.unloadJSON(obj);
                result.setTotalDays(JsonHelper.getInt(obj, "total_days"));
                return result;
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static ReadingPlanCollection search(ApiConnection conn, final String query, final String category, final String totalDays, final String languageTag, final String sort, final int page) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (query != null) {
                    this.put("query", query.toString());
                }
                if (category != null) {
                    this.put("category", category.toString());
                }
                if (totalDays != null) {
                    this.put("total_days", totalDays.toString());
                }
                if (languageTag != null) {
                    this.put("language_tag", languageTag.toString());
                }
                if (sort != null) {
                    this.put("sort", sort.toString());
                }
                this.put("page", String.valueOf(page));
            }
        };
        String url = ApiBase.URL_BASE + "/reading_plans/search.json" + ReadingPlanApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (ReadingPlanApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return ReadingPlanCollection.unloadJSON(data);
            }
            if (code == 404) {
                return ApiBase.getApiFactory().newReadingPlanCollection();
            }
            innerEx = ReadingPlanApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }
}

