/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.Note;
import com.youversion.objects.NoteCollection;
import com.youversion.objects.Reference;
import com.youversion.objects.ReferenceCollection;
import java.util.Hashtable;
import org.json.me.JSONArray;
import org.json.me.JSONObject;

public class NotesApi
extends ApiBase {
    public static NoteCollection items(ApiConnection conn, String username, String password, final Integer userId, final String refs, final int page, final String userStatus) throws YouVersionApiException {
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (userId != null) {
                    this.put("user_id", userId);
                }
                if (refs != null) {
                    this.put("reference", refs);
                }
                if (userStatus != null) {
                    this.put("user_status", userStatus);
                }
                this.put("page", String.valueOf(page));
            }
        };
        return NotesApi.itemsByMap(conn, username, password, map);
    }

    public static NoteCollection items(ApiConnection conn, String username, String password, Integer userId, Reference ref, int page, String userStatus) throws YouVersionApiException {
        return NotesApi.items(conn, username, password, userId, ref == null ? null : ref.getOsis(), page, userStatus);
    }

    public static NoteCollection items(ApiConnection conn, String username, String password, Integer userId, ReferenceCollection refs, int page, String userStatus) throws YouVersionApiException {
        return NotesApi.items(conn, username, password, userId, refs == null ? null : refs.toOsis(), page, userStatus);
    }

    public static NoteCollection items(ApiConnection conn, Integer userId, String refs, int page) throws YouVersionApiException {
        return NotesApi.items(conn, null, null, userId, refs, page, null);
    }

    public static NoteCollection items(ApiConnection conn, Integer userId, ReferenceCollection refs, int page) throws YouVersionApiException {
        return NotesApi.items(conn, null, null, userId, refs, page, null);
    }

    public static NoteCollection items(ApiConnection conn, Integer userId, Reference reference, int page) throws YouVersionApiException {
        return NotesApi.items(conn, null, null, userId, reference, page, null);
    }

    public static NoteCollection search(ApiConnection conn, String username, String password, final String search, final int page) throws YouVersionApiException {
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (search != null) {
                    this.put("search", search);
                }
                this.put("page", String.valueOf(page));
            }
        };
        return NotesApi.itemsByMap(conn, username, password, map);
    }

    public static Note view(ApiConnection conn, String username, String password, final Long id) throws YouVersionApiException {
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("id", id);
            }
        };
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/notes/view.json" + NotesApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (NotesApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return Note.unloadJSON(data);
            }
            innerEx = NotesApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static Note view(ApiConnection conn, Long id) throws YouVersionApiException {
        return NotesApi.view(conn, null, null, id);
    }

    private static NoteCollection itemsByMap(ApiConnection conn, String username, String password, Hashtable map) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/notes/items.json" + NotesApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (NotesApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return NoteCollection.unloadJSON(data);
            }
            innerEx = NotesApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static Note create(ApiConnection conn, String username, String password, final Note note, final String connections) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("title", note.getTitle());
                this.put("content", note.getContentYvml());
                if (note.getReferences().size() > 0) {
                    this.put("reference", note.getReferences().toOsis());
                    this.put("version", note.getVersion());
                }
                if (note.getLanguageIso() != null) {
                    this.put("language_iso", note.getLanguageIso());
                }
                if (note.getPublished() != null) {
                    this.put("published", note.getPublished());
                }
                if (connections != null) {
                    this.put("share_connections", connections);
                }
                if (note.getHighlightColor() != null) {
                    this.put("highlight_color", note.getHighlightColor());
                }
                this.put("user_status", note.getUserStatus());
            }
        };
        String url = ApiBase.URL_BASE + "/notes/create.json";
        try {
            byte[] data = NotesApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (NotesApi.isSuccess(code)) {
                JSONObject json = parsed.getJSONObject("data");
                return Note.unloadJSON(json);
            }
            innerEx = NotesApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static Note update(ApiConnection conn, String username, String password, final Note note, final String connections) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("id", Long.toString(note.getId()));
                this.put("title", note.getTitle());
                this.put("content", note.getContentYvml());
                if (note.getReferences().size() > 0) {
                    this.put("reference", note.getReferences().toOsis());
                    this.put("version", note.getVersion());
                }
                if (note.getLanguageIso() != null) {
                    this.put("language_iso", note.getLanguageIso());
                }
                if (note.getPublished() != null) {
                    this.put("published", note.getPublished());
                }
                if (connections != null) {
                    this.put("share_connections", connections);
                }
                if (note.getHighlightColor() != null) {
                    this.put("highlight_color", note.getHighlightColor());
                }
                this.put("user_status", note.getUserStatus());
            }
        };
        String url = ApiBase.URL_BASE + "/notes/update.json";
        try {
            byte[] data = NotesApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (NotesApi.isSuccess(code)) {
                JSONObject json = parsed.getJSONObject("data");
                return Note.unloadJSON(json);
            }
            innerEx = NotesApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static boolean delete(ApiConnection conn, String username, String password, long id) throws YouVersionApiException {
        return NotesApi.post(conn, username, password, "/notes/delete.json", "id=" + id);
    }

    private static boolean post(ApiConnection conn, String username, String password, String path, String data) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + path;
        try {
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data.getBytes(), username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            return NotesApi.isSuccess(code);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static boolean createLike(ApiConnection conn, String username, String password, long id) throws YouVersionApiException {
        return NotesApi.post(conn, username, password, "/likes/create.json", "note_id=" + id);
    }

    public static boolean deleteLike(ApiConnection conn, String username, String password, long id) throws YouVersionApiException {
        return NotesApi.post(conn, username, password, "/likes/delete.json", "note_id=" + id);
    }

    public static boolean report(ApiConnection conn, String username, String password, long id) throws YouVersionApiException {
        return NotesApi.post(conn, username, password, "/notes/report.json", "id=" + id);
    }

    public static long[] allLikes(ApiConnection conn, int userId) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/users/all_likes.json?user_id=" + userId;
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (NotesApi.isSuccess(code)) {
                JSONArray data = parsed.getJSONArray("data");
                long[] likes = new long[data.length()];
                for (int i = 0; i < data.length(); ++i) {
                    likes[i] = data.getInt(i);
                }
                return likes;
            }
            if (code == 404) {
                return new long[0];
            }
            innerEx = NotesApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static Note append(ApiConnection conn, String username, String password, final Note note, final String textToAppend, final String connections) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("id", "" + note.getId());
                this.put("title", note.getTitle());
                this.put("content", textToAppend);
                if (note.getLanguageIso() != null) {
                    this.put("language_iso", note.getLanguageIso());
                }
                if (note.getReferences().size() > 0) {
                    this.put("reference", note.getReferences().toOsis());
                    this.put("version", note.getVersion());
                }
                if (note.getPublished() != null) {
                    this.put("published", note.getPublished());
                }
                this.put("user_status", note.getUserStatus());
                if (connections != null) {
                    this.put("share_connections", connections);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/notes/append.json";
        try {
            byte[] data = NotesApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (NotesApi.isSuccess(code)) {
                JSONObject json = parsed.getJSONObject("data");
                return Note.unloadJSON(json);
            }
            innerEx = NotesApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }
}

