/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.LiveEventCollection;
import java.util.Hashtable;
import org.json.me.JSONObject;

public class LiveApi
extends ApiBase {
    public static LiveEventCollection search(ApiConnection conn, String location) throws YouVersionApiException {
        return LiveApi.search(conn, location, null, null);
    }

    public static LiveEventCollection search(ApiConnection conn, double latitude, double longitude) throws YouVersionApiException {
        return LiveApi.search(conn, null, new Double(latitude), new Double(longitude));
    }

    private static LiveEventCollection search(ApiConnection conn, final String location, final Double latitude, final Double longitude) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (location != null) {
                    this.put("location", location);
                }
                if (latitude != null) {
                    this.put("geo_latitude", latitude);
                }
                if (longitude != null) {
                    this.put("geo_longitude", longitude);
                }
                this.put("live", "true");
                this.put("published", "true");
            }
        };
        String url = ApiBase.URL_BASE + "/live/search.json" + LiveApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (LiveApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return LiveEventCollection.unloadJSON(data.getJSONArray("events"));
            }
            innerEx = LiveApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }
}

