/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.LiveEventPollResultItem;
import java.util.Hashtable;
import org.json.me.JSONObject;

public class EventItemsApi
extends ApiBase {
    public static boolean createPollResponse(ApiConnection conn, final int id, final String uniqueId, final String pollResponse) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("event_item_id", Integer.toString(id));
                this.put("user_identifier", uniqueId);
                this.put("response", pollResponse);
            }
        };
        String url = ApiBase.URL_BASE + "/event_items/create_poll_response.json";
        try {
            String data = EventItemsApi.buildQueryString(map).substring(1);
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data.getBytes());
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            return EventItemsApi.isSuccess(code);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static boolean createQAResponse(ApiConnection conn, final int id, final String uniqueId, final String response) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("event_item_id", Integer.toString(id));
                this.put("user_identifier", uniqueId);
                this.put("response", response);
            }
        };
        String url = ApiBase.URL_BASE + "/event_items/create_qa_response.json";
        try {
            String data = EventItemsApi.buildQueryString(map).substring(1);
            ApiConnection.ApiResponse httpResponse = conn.makePostRequest(url, data.getBytes());
            httpResponse.assertSuccess();
            JSONObject parsed = new JSONObject(httpResponse.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (EventItemsApi.isSuccess(code)) {
                return true;
            }
            innerEx = EventItemsApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static boolean createPrayerResponse(ApiConnection conn, final int id, final String name, final String contactInfo, final String prayer) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("event_item_id", Integer.toString(id));
                if (name != null) {
                    this.put("name", name);
                }
                if (contactInfo != null) {
                    this.put("contact_info", contactInfo);
                }
                this.put("prayer", prayer);
            }
        };
        String url = ApiBase.URL_BASE + "/event_items/create_prayer_response.json";
        try {
            String data = EventItemsApi.buildQueryString(map).substring(1);
            ApiConnection.ApiResponse httpResponse = conn.makePostRequest(url, data.getBytes());
            httpResponse.toString();
            JSONObject parsed = new JSONObject(httpResponse.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (EventItemsApi.isSuccess(code)) {
                return true;
            }
            innerEx = EventItemsApi.buildReadException(parsed);
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static LiveEventPollResultItem viewPollResults(ApiConnection conn, final int id) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("event_item_id", Integer.toString(id));
            }
        };
        String url = ApiBase.URL_BASE + "/event_items/view_poll_results.json" + EventItemsApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (EventItemsApi.isSuccess(code)) {
                JSONObject obj = parsed.getJSONObject("data").getJSONObject("event_item");
                return LiveEventPollResultItem.unloadJSON(obj);
            }
            innerEx = EventItemsApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }
}

