/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.BibleSearchResult;
import com.youversion.objects.BookCollection;
import com.youversion.objects.Verse;
import com.youversion.objects.VerseCollection;
import com.youversion.objects.VersionCollection;
import java.io.IOException;
import java.util.Hashtable;
import org.json.me.JSONObject;

public class BibleApi
extends ApiBase {
    public static BookCollection getBooks(ApiConnection conn, final String version) throws YouVersionApiException {
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (version != null) {
                    this.put("version", version);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/bible/books.json" + BibleApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            return BookCollection.unloadResponse(response.toString());
        }
        catch (YouVersionApiException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new YouVersionApiException(ex);
        }
    }

    public static VerseCollection getVerse(ApiConnection conn, final String version, final String reference) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (version != null) {
                    this.put("version", version);
                }
                if (reference != null) {
                    this.put("reference", reference);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/bible/verse.json" + BibleApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (BibleApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return VerseCollection.unloadJSON(data.getJSONArray("items"));
            }
            innerEx = BibleApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static Verse getVerseOfTheDay(ApiConnection conn, final String version, final int day) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (version != null) {
                    this.put("version", version);
                }
                this.put("day", new Integer(day));
            }
        };
        String url = ApiBase.URL_BASE + "/bible/verse_of_the_day.json" + BibleApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (BibleApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data").getJSONArray("references").getJSONObject(0);
                Verse v = ApiBase.getApiFactory().newVerse();
                v.unloadJSON(data);
                return v;
            }
            innerEx = BibleApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static VersionCollection getVersions(ApiConnection conn) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/bible/versions.json";
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (BibleApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return VersionCollection.unloadJSON(data);
            }
            innerEx = BibleApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable ex) {
            innerEx = new YouVersionApiException(ex);
        }
        throw innerEx;
    }

    public static BibleSearchResult search(ApiConnection conn, String search, String version, int page) throws YouVersionApiException {
        return BibleApi.search(conn, search, version, null, null, null, null, page);
    }

    public static BibleSearchResult search(ApiConnection conn, final String search, final String version, final String language, final String canonFacet, final String bookFacet, final String sort, final int page) throws YouVersionApiException {
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (search != null) {
                    this.put("query", search);
                }
                if (version != null) {
                    this.put("version", version);
                }
                if (language != null) {
                    this.put("language_tag", language.toLowerCase());
                }
                if (canonFacet != null) {
                    this.put("canon", canonFacet.toLowerCase());
                }
                if (bookFacet != null) {
                    this.put("book", bookFacet);
                }
                if (sort != null) {
                    this.put("sort", sort);
                }
                this.put("page", String.valueOf(page));
            }
        };
        String url = ApiBase.URL_BASE + "/bible/search.json" + BibleApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            return BibleApi.itemsUnloadMany(response.toString());
        }
        catch (IOException e) {
            throw new YouVersionApiException(e);
        }
    }

    protected static BibleSearchResult itemsUnloadMany(String response) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        try {
            JSONObject parsed = new JSONObject(response).getJSONObject("response");
            int code = parsed.getInt("code");
            if (BibleApi.isSuccess(code)) {
                BibleSearchResult collection = ApiBase.getApiFactory().newBibleSearchResult();
                JSONObject data = parsed.getJSONObject("data");
                collection.unloadJSON(data);
                return collection;
            }
            innerEx = BibleApi.buildReadException(parsed);
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }

    public static String getCopyright(ApiConnection conn, final String version, final String format) throws YouVersionApiException {
        YouVersionApiException ex = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (version != null) {
                    this.put("version", version);
                }
                if (format != null) {
                    this.put("format", format);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/bible/copyright.json" + BibleApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (code != 200) {
                throw new YouVersionApiException(code, parsed.getString("data"));
            }
            return parsed.getJSONObject("data").getString("copyright");
        }
        catch (YouVersionApiException e) {
            ex = e;
        }
        catch (Throwable e) {
            ex = new YouVersionApiException(e);
        }
        throw ex;
    }
}

