/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.util;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.microemu.util.JadMidletEntry;

public class JadProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    static String MIDLET_PREFIX = "MIDlet-";
    Vector midletEntries = null;
    String correctedJarURL = null;

    public void clear() {
        super.clear();
        this.midletEntries = null;
        this.correctedJarURL = null;
    }

    public String getSuiteName() {
        return this.getProperty("MIDlet-Name");
    }

    public String getVersion() {
        return this.getProperty("MIDlet-Version");
    }

    public String getVendor() {
        return this.getProperty("MIDlet-Vendor");
    }

    public String getProfile() {
        return this.getProperty("MicroEdition-Profile");
    }

    public String getConfiguration() {
        return this.getProperty("MicroEdition-Configuration");
    }

    public String getJarURL() {
        if (this.correctedJarURL != null) {
            return this.correctedJarURL;
        }
        return this.getProperty("MIDlet-Jar-URL");
    }

    public void setCorrectedJarURL(String correctedJarURL) {
        this.correctedJarURL = correctedJarURL;
    }

    public int getJarSize() {
        return Integer.parseInt(this.getProperty("MIDlet-Jar-Size"));
    }

    public Vector getMidletEntries() {
        if (this.midletEntries == null) {
            this.midletEntries = new Vector();
            Enumeration<?> e = this.propertyNames();
            while (e.hasMoreElements()) {
                String test = (String)e.nextElement();
                if (!test.startsWith(MIDLET_PREFIX)) continue;
                try {
                    Integer.parseInt(test.substring(MIDLET_PREFIX.length()));
                    test = this.getProperty(test);
                    int pos = test.indexOf(44);
                    String name = test.substring(0, pos).trim();
                    String icon = test.substring(pos + 1, test.indexOf(44, pos + 1)).trim();
                    String className = test.substring(test.indexOf(44, pos + 1) + 1).trim();
                    this.midletEntries.addElement(new JadMidletEntry(name, icon, className));
                }
                catch (NumberFormatException ex) {}
            }
        }
        return this.midletEntries;
    }

    public String getProperty(String key, String defaultValue) {
        String result = super.getProperty(key, defaultValue);
        if (result != null) {
            return result.trim();
        }
        return null;
    }

    public String getProperty(String key) {
        String result = super.getProperty(key);
        if (result != null) {
            return result.trim();
        }
        return null;
    }
}

