/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.cldc.file;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Vector;
import javax.microedition.io.Connection;
import org.microemu.cldc.file.FileSystem;
import org.microemu.cldc.file.FileSystemFileConnection;
import org.microemu.log.Logger;
import org.microemu.microedition.ImplementationUnloadable;
import org.microemu.microedition.io.ConnectorAdapter;

public class FileSystemConnectorImpl
extends ConnectorAdapter
implements ImplementationUnloadable {
    public static final String PROTOCOL = "file://";
    private AccessControlContext acc;
    private String fsRoot;
    private List openConnection = new Vector();

    FileSystemConnectorImpl(String fsRoot) {
        this.acc = AccessController.getContext();
        this.fsRoot = fsRoot;
    }

    public Connection open(final String name, int mode, boolean timeouts) throws IOException {
        if (!name.startsWith(PROTOCOL)) {
            throw new IOException("Invalid Protocol " + name);
        }
        Connection con = (Connection)FileSystemConnectorImpl.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return new FileSystemFileConnection(FileSystemConnectorImpl.this.fsRoot, name.substring(FileSystemConnectorImpl.PROTOCOL.length()), FileSystemConnectorImpl.this);
            }
        }, this.acc);
        this.openConnection.add(con);
        return con;
    }

    static Object doPrivilegedIO(PrivilegedExceptionAction action, AccessControlContext context) throws IOException {
        try {
            return AccessController.doPrivileged(action, context);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.toString());
        }
    }

    void notifyMIDletDestroyed() {
        if (this.openConnection.size() > 0) {
            Logger.warn("Still has " + this.openConnection.size() + " open file connections");
        }
    }

    public void unregisterImplementation() {
        FileSystem.unregisterImplementation(this);
    }

    void notifyClosed(FileSystemFileConnection con) {
        this.openConnection.remove(con);
    }
}

