/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.microemu.MIDletBridge;
import org.microemu.MIDletContext;
import org.microemu.log.Logger;

public class MIDletTimer
extends Timer {
    private static Map midlets = new WeakHashMap();
    private String name;
    private MIDletContext midletContext;

    public MIDletTimer() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        this.name = ste[1].getClassName() + "." + ste[1].getMethodName();
    }

    public void schedule(TimerTask task, Date time) {
        MIDletTimer.register(this);
        super.schedule(task, time);
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        MIDletTimer.register(this);
        super.schedule(task, firstTime, period);
    }

    public void schedule(TimerTask task, long delay) {
        MIDletTimer.register(this);
        super.schedule(task, delay);
    }

    public void schedule(TimerTask task, long delay, long period) {
        MIDletTimer.register(this);
        super.schedule(task, delay, period);
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        MIDletTimer.register(this);
        super.schedule(task, firstTime, period);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        MIDletTimer.register(this);
        super.scheduleAtFixedRate(task, delay, period);
    }

    public void cancel() {
        MIDletTimer.unregister(this);
        super.cancel();
    }

    private void terminate() {
        super.cancel();
    }

    private static void register(MIDletTimer timer) {
        if (timer.midletContext == null) {
            timer.midletContext = MIDletBridge.getMIDletContext();
        }
        if (timer.midletContext == null) {
            Logger.error("Creating Timer with no MIDlet context", new Throwable());
            return;
        }
        HashMap<MIDletTimer, MIDletContext> timers = (HashMap<MIDletTimer, MIDletContext>)midlets.get(timer.midletContext);
        if (timers == null) {
            timers = new HashMap<MIDletTimer, MIDletContext>();
            midlets.put(timer.midletContext, timers);
        }
        timers.put(timer, timer.midletContext);
    }

    private static void unregister(MIDletTimer timer) {
        if (timer.midletContext == null) {
            return;
        }
        Map timers = (Map)midlets.get(timer.midletContext);
        if (timers == null) {
            return;
        }
        timers.remove(timer);
    }

    public static void contextDestroyed(MIDletContext midletContext) {
        if (midletContext == null) {
            return;
        }
        Map timers = (Map)midlets.get(midletContext);
        if (timers != null) {
            MIDletTimer.terminateTimers(timers);
            midlets.remove(midletContext);
        }
    }

    private static void terminateTimers(Map timers) {
        Iterator iter = timers.keySet().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) continue;
            if (o instanceof MIDletTimer) {
                MIDletTimer tm = (MIDletTimer)o;
                Logger.warn("MIDlet timer created from [" + tm.name + "] still running");
                tm.terminate();
                continue;
            }
            Logger.debug("unrecognized Object [" + o.getClass().getName() + "]");
        }
    }
}

