/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.xml;

import de.enough.polish.util.ArrayList;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class XmlDomNode {
    private XmlDomNode parent;
    private final ArrayList childList;
    private Hashtable attributes;
    private String name;
    private int type;
    private String text;

    public XmlDomNode(XmlDomNode parent, String name, int type) {
        this(parent, name, null, type);
    }

    public XmlDomNode(XmlDomNode parent, String name, Hashtable attributes, int type) {
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = name;
        this.attributes = attributes;
        this.type = type;
        this.childList = new ArrayList();
    }

    public XmlDomNode getChild(String childName) {
        XmlDomNode child;
        int i;
        for (i = 0; i < this.childList.size(); ++i) {
            child = (XmlDomNode)this.childList.get(i);
            if (!childName.equals(child.getName())) continue;
            return child;
        }
        childName = childName.toLowerCase();
        for (i = 0; i < this.childList.size(); ++i) {
            child = (XmlDomNode)this.childList.get(i);
            if (!childName.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public XmlDomNode getChild(int index) {
        return (XmlDomNode)this.childList.get(index);
    }

    public void addChild(XmlDomNode childNode) {
        this.childList.add(childNode);
    }

    public int getChildCount() {
        return this.childList.size();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XmlDomNode getParent() {
        return this.parent;
    }

    public void setParent(XmlDomNode parent) {
        this.parent = parent;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Hashtable attributes) {
        this.attributes = attributes;
    }

    public String getAttribute(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(attributeName);
    }

    public String getChildText(String childName) {
        XmlDomNode child = this.getChild(childName);
        return child != null ? child.getText() : null;
    }

    public XmlDomNode[] getChildren() {
        return (XmlDomNode[])this.childList.toArray(new XmlDomNode[this.childList.size()]);
    }

    public XmlDomNode[] getChildren(String childName) {
        return this.getChildren(childName, false);
    }

    public XmlDomNode[] getChildren(String childName, boolean recursive) {
        ArrayList children = new ArrayList();
        this.getChildren(childName, recursive, children);
        return (XmlDomNode[])children.toArray(new XmlDomNode[children.size()]);
    }

    public void getChildren(String childName, boolean recursive, ArrayList resultList) {
        XmlDomNode child;
        Object[] objects = this.childList.getInternalArray();
        for (int i = 0; i < objects.length && (child = (XmlDomNode)objects[i]) != null; ++i) {
            if (childName.equals(child.getName())) {
                resultList.add(child);
            }
            if (!recursive) continue;
            child.getChildren(childName, recursive, resultList);
        }
    }

    public String toXmlString() {
        return this.toXmlString(true);
    }

    public String toXmlString(boolean useWhitespace) {
        StringBuffer xml = new StringBuffer();
        this.appendXmlString("", xml, useWhitespace);
        return xml.toString();
    }

    protected void appendXmlString(String indent, StringBuffer xml) {
        this.appendXmlString(indent, xml, true);
    }

    protected void appendXmlString(String indent, StringBuffer xml, boolean useWhitespace) {
        xml.append(indent).append('<').append(this.name);
        if (this.attributes != null) {
            Enumeration keys = this.attributes.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)this.attributes.get(key);
                xml.append(' ').append(key).append("=\"").append(value).append("\"");
            }
        }
        xml.append('>');
        String childIndent = "";
        if (useWhitespace) {
            xml.append('\n');
            childIndent = ' ' + indent;
        }
        if (this.text != null) {
            xml.append(childIndent).append(this.text);
            if (useWhitespace) {
                xml.append('\n');
            }
        }
        if (this.childList != null) {
            for (int i = 0; i < this.childList.size(); ++i) {
                XmlDomNode node = (XmlDomNode)this.childList.get(i);
                node.appendXmlString(childIndent, xml, useWhitespace);
            }
        }
        xml.append(indent).append("</").append(this.name).append(">");
        if (useWhitespace) {
            xml.append('\n');
        }
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        this.print(this, "", out);
    }

    private void print(XmlDomNode node, String start, PrintStream out) {
        out.print(start);
        out.print('<');
        out.print(node.name);
        if (node.attributes != null) {
            Enumeration attrEnum = node.attributes.keys();
            while (attrEnum.hasMoreElements()) {
                String attrName = (String)attrEnum.nextElement();
                String attrValue = (String)node.attributes.get(attrName);
                out.print(' ');
                out.print(attrName);
                out.print('=');
                out.print('\"');
                out.print(attrValue);
                out.print('\"');
            }
        }
        if (node.text == null && node.childList == null) {
            out.println("/>");
        } else {
            out.println('>');
            if (node.text != null) {
                out.print(start);
                out.println(node.text);
            }
            if (node.childList != null) {
                XmlDomNode child;
                Object[] objects = node.childList.getInternalArray();
                String childStart = start + "  ";
                for (int i = 0; i < objects.length && (child = (XmlDomNode)objects[i]) != null; ++i) {
                    this.print(child, childStart, out);
                }
            }
            out.print(start);
            out.print("</");
            out.print(node.name);
            out.println('>');
        }
    }
}

