/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.video.util;

import de.enough.polish.util.ArrayList;
import de.enough.polish.util.TextUtil;
import de.enough.polish.video.util.VideoEncoding;

public class VideoEncodingList {
    private ArrayList encodings;

    public VideoEncodingList() {
        this(null);
    }

    public VideoEncodingList(VideoEncoding filter) {
        String encodingsProperty = System.getProperty("video.encodings");
        ArrayList allEncodings = this.parseEncodings(encodingsProperty);
        this.encodings = filter == null ? allEncodings : this.filterEncodings(allEncodings, filter);
    }

    private ArrayList parseEncodings(String videoEncodings) {
        String[] splittedEncodings = TextUtil.split(videoEncodings, ' ');
        ArrayList resultEncodings = new ArrayList();
        for (int index = 0; index < splittedEncodings.length; ++index) {
            String encoding = splittedEncodings[index];
            resultEncodings.add(new VideoEncoding(encoding));
        }
        return resultEncodings;
    }

    private ArrayList filterEncodings(ArrayList encodings, VideoEncoding filter) {
        ArrayList filteredEncodings = new ArrayList();
        for (int index = 0; index < encodings.size(); ++index) {
            String audioCodec;
            String videoCodec;
            String height;
            String width;
            VideoEncoding encoding = (VideoEncoding)encodings.get(index);
            String mime = filter.getEncoding();
            if (mime != null && !mime.equals(encoding.getEncoding()) || (width = filter.getWidth()) != null && !width.equals(encoding.getWidth()) || (height = filter.getHeight()) != null && !height.equals(encoding.getHeight()) || (videoCodec = filter.getVideoCodec()) != null && !videoCodec.equals(encoding.getVideoCodec()) || (audioCodec = filter.getAudioCodec()) != null && !audioCodec.equals(encoding.getAudioCodec())) continue;
            filteredEncodings.add(encoding);
        }
        return filteredEncodings;
    }

    public int size() {
        return this.encodings.size();
    }

    public VideoEncoding get(int index) {
        return (VideoEncoding)this.encodings.get(index);
    }

    public VideoEncoding[] toArray() {
        return (VideoEncoding[])this.encodings.toArray(new VideoEncoding[this.encodings.size()]);
    }
}

