/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.video.util;

import de.enough.polish.util.HashMap;
import de.enough.polish.util.TextUtil;
import de.enough.polish.util.ToStringHelper;

public class VideoEncoding {
    private static final String ENCODING = "encoding";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String VIDEO_CODEC = "video_codec";
    private static final String AUDIO_CODEC = "audio_codec";
    private static final String MODE = "mode";
    private final String descriptor;
    private final String encoding;
    private final String width;
    private final String height;
    private final String videoCodec;
    private final String audioCodec;
    private final String mode;

    public VideoEncoding(String encoding) throws IllegalArgumentException {
        this.descriptor = encoding;
        HashMap encodingMap = this.parseEncoding(encoding);
        this.encoding = (String)encodingMap.get(ENCODING);
        this.width = (String)encodingMap.get(WIDTH);
        this.height = (String)encodingMap.get(HEIGHT);
        this.videoCodec = (String)encodingMap.get(VIDEO_CODEC);
        this.audioCodec = (String)encodingMap.get(AUDIO_CODEC);
        this.mode = (String)encodingMap.get(MODE);
    }

    public VideoEncoding(String encoding, String width, String height, String videoCodec, String audioCodec, String mode) {
        this.descriptor = null;
        this.encoding = encoding;
        this.width = width;
        this.height = height;
        this.videoCodec = videoCodec;
        this.audioCodec = audioCodec;
        this.mode = mode;
    }

    private String[] parseEncodingValue(String pair) {
        return TextUtil.split(pair, '=');
    }

    private HashMap parseEncoding(String encoding) throws IllegalArgumentException {
        HashMap encodingMap = new HashMap();
        String[] encodingValues = TextUtil.split(encoding, '&');
        for (int index = 0; index < encodingValues.length; ++index) {
            String encodingValue = encodingValues[index];
            String[] encodingPair = this.parseEncodingValue(encodingValue);
            if (encodingPair.length != 2) {
                throw new IllegalArgumentException(encoding + " has wrong format");
            }
            String key = encodingPair[0];
            String value = encodingPair[1];
            encodingMap.put(key, value);
        }
        return encodingMap;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public String getAudioCodec() {
        return this.audioCodec;
    }

    public String getMode() {
        return this.mode;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toResolutionString() {
        return this.width + "x" + this.height;
    }

    public String toString() {
        return new ToStringHelper(this).set(ENCODING, this.encoding).set(WIDTH, this.width).set(HEIGHT, this.height).set(VIDEO_CODEC, this.videoCodec).set(AUDIO_CODEC, this.audioCodec).set(MODE, this.mode).toString();
    }
}

