/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.video.control;

import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.Style;
import de.enough.polish.video.VideoCallback;
import de.enough.polish.video.VideoContainer;
import de.enough.polish.video.VideoSource;

public class VolumeControlItem
extends Gauge
implements VideoCallback,
ItemStateListener {
    public static final int MAX_VOLUME = 100;
    public static final int STEPS = 10;
    VideoContainer video;

    public VolumeControlItem(VideoContainer item) {
        this(item, null);
    }

    public VolumeControlItem(VideoContainer item, Style style) {
        super(null, true, 10, 0, style);
        this.video = item;
        this.video.addCallback(this);
        this.setValue(10);
        this.setItemStateListener(this);
    }

    public void setVolume(int percent) {
        int value = percent / 100 * 10;
        this.setValue(value);
    }

    public void onVideoReady() {
        this.video.setVolume(this.getValue() * 10);
    }

    public void onVideoPartReady(VideoSource source) {
    }

    public void onVideoError(Exception e) {
    }

    public void onVideoPause() {
    }

    public void onVideoPlay() {
    }

    public void onVideoStop() {
    }

    public void onVideoClose() {
    }

    public void itemStateChanged(Item item) {
        if (this.video.getState() != 0) {
            int volume = 10 * this.getValue();
            this.video.setVolume(volume);
        }
    }

    public void onSnapshot(byte[] data, String encoding) {
    }
}

