/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.video;

import de.enough.polish.io.Serializer;
import de.enough.polish.snapshot.SnapshotUtil;
import de.enough.polish.util.Debug;
import de.enough.polish.video.VideoSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class CaptureSource
extends VideoSource {
    private boolean isSnapshotInProgress;
    private boolean isAutofocusEnabled;
    private boolean isInitializing;
    private String protocol;

    public CaptureSource() throws MediaException {
        this(SnapshotUtil.getProtocol());
    }

    public CaptureSource(String protocol) {
        super("capture", protocol, null);
        this.protocol = protocol;
    }

    protected void open() throws Exception {
        this.player = Manager.createPlayer(this.protocol);
        this.player.realize();
        this.player.prefetch();
        this.videoControl = (VideoControl)this.player.getControl("VideoControl");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] capture(String encoding) throws MediaException {
        if (this.isSnapshotInProgress) {
            throw new MediaException("Snapshot in progress");
        }
        this.isSnapshotInProgress = true;
        int step = 0;
        try {
            try {
                String message;
                byte[] data;
                VideoControl vc;
                block13: {
                    vc = this.videoControl;
                    Player pl = this.player;
                    if (vc == null) throw new MediaException("Unable to init snapshot");
                    if (pl.getState() == 0) {
                        throw new MediaException("Unable to init snapshot");
                    }
                    step = 1;
                    data = null;
                    message = null;
                    try {
                        String supported;
                        step = 4;
                        if (encoding != null && (supported = System.getProperty("video.snapshot.encodings")) != null && supported.indexOf(32) == -1) {
                            encoding = supported;
                        }
                        data = vc.getSnapshot(encoding);
                    }
                    catch (MediaException e) {
                        if (encoding != null) break block13;
                        throw e;
                    }
                }
                if (data == null && encoding != null) {
                    try {
                        step = 5;
                        data = vc.getSnapshot(null);
                    }
                    catch (MediaException e) {
                        throw new MediaException("(1): " + message + " enc=[" + encoding + "], (2):" + e.getMessage() + ", supported:[" + System.getProperty("video.snapshot.encodings") + "]");
                    }
                }
                this.isSnapshotInProgress = false;
                this.stopSnapshot();
                byte[] byArray = data;
                Object var9_12 = null;
                this.isSnapshotInProgress = false;
                return byArray;
            }
            catch (MediaException e) {
                Debug.debug("error", "de.enough.polish.video.CaptureSource", 166, (Object)"Unable to take snapshot ", e);
                throw e;
            }
            catch (Throwable e) {
                Debug.debug("error", "de.enough.polish.video.CaptureSource", 170, (Object)("Unable to take snapshot at step " + step), e);
                if (!(e instanceof SecurityException)) throw new MediaException(e.toString() + " at step " + step);
                throw (SecurityException)e;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.isSnapshotInProgress = false;
            throw throwable;
        }
    }

    private void stopSnapshot() {
    }

    public void setAutofocus(boolean autofocus) {
        this.isAutofocusEnabled = autofocus;
    }

    public boolean isBusy() {
        return this.isSnapshotInProgress || this.isInitializing;
    }

    public boolean isSnapshotInProgress() {
        return this.isSnapshotInProgress;
    }

    public boolean isAutofocus() {
        boolean result = false;
        return result;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.isAutofocusEnabled = dataInputStream.readBoolean();
        this.isInitializing = dataInputStream.readBoolean();
        this.isSnapshotInProgress = dataInputStream.readBoolean();
        this.protocol = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.isAutofocusEnabled);
        dataOutputStream.writeBoolean(this.isInitializing);
        dataOutputStream.writeBoolean(this.isSnapshotInProgress);
        Serializer.serialize(this.protocol, dataOutputStream);
    }
}

