/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.zip.GZipInputStream;
import de.enough.polish.util.zip.GZipOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class ZipUtil {
    public static byte[] decompress(byte[] data) throws IOException {
        return ZipUtil.decompress(data, 0);
    }

    public static byte[] decompress(byte[] data, int compressionType) throws IOException {
        int read;
        byte[] tmp = new byte[1024];
        GZipInputStream zipInputStream = new GZipInputStream(new ByteArrayInputStream(data), 1024, compressionType, true);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        while ((read = zipInputStream.read(tmp, 0, 1024)) > 0) {
            bout.write(tmp, 0, read);
        }
        return bout.toByteArray();
    }

    public static byte[] compress(byte[] data) throws IOException {
        return ZipUtil.compress(data, 0);
    }

    public static byte[] compress(byte[] data, int compressionType) throws IOException {
        if (data.length > 32768) {
            return ZipUtil.compress(data, compressionType, 32768, 32768);
        }
        return ZipUtil.compress(data, compressionType, data.length, data.length);
    }

    public static byte[] compress(byte[] data, int compressionType, int plainWindowSize, int huffmanWindowSize) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        GZipOutputStream zipOutputStream = new GZipOutputStream(bout, 1024, compressionType, plainWindowSize, huffmanWindowSize);
        zipOutputStream.write(data);
        zipOutputStream.close();
        return bout.toByteArray();
    }

    public static byte[] compressIntArray(int[] rgb) throws IOException {
        return ZipUtil.compress(ZipUtil.convertIntToByteArray(rgb));
    }

    public static byte[] convertIntToByteArray(int[] rgb) {
        byte[] data = new byte[rgb.length * 4];
        int j = 0;
        for (int i = 0; i < rgb.length; ++i) {
            int v = rgb[i];
            data[j + 0] = (byte)(v >>> 24 & 0xFF);
            data[j + 1] = (byte)(v >>> 16 & 0xFF);
            data[j + 2] = (byte)(v >>> 8 & 0xFF);
            data[j + 3] = (byte)(v >>> 0 & 0xFF);
            j += 4;
        }
        return data;
    }

    public static int[] decompressIntArray(byte[] data) throws IOException {
        return ZipUtil.convertByteToIntArray(ZipUtil.decompress(data, 0));
    }

    public static int[] convertByteToIntArray(byte[] data) {
        int[] rgb = new int[data.length / 4];
        int j = 0;
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = (data[j + 0] & 0xFF) << 24 | (data[j + 1] & 0xFF) << 16 | (data[j + 2] & 0xFF) << 8 | (data[j + 3] & 0xFF) << 0;
            j += 4;
        }
        return rgb;
    }

    public static byte[] compressRgbArray(int[] rgb) throws IOException {
        return ZipUtil.compress(ZipUtil.convertRgbToByteArray(rgb, 0, rgb.length));
    }

    public static byte[] compressRgbArray(int[] rgb, int offset, int len) throws IOException {
        return ZipUtil.compress(ZipUtil.convertRgbToByteArray(rgb, offset, len));
    }

    public static byte[] convertRgbToByteArray(int[] rgb) {
        return ZipUtil.convertRgbToByteArray(rgb, 0, rgb.length);
    }

    public static byte[] convertRgbToByteArray(int[] rgb, int offset, int len) {
        byte[] data = new byte[len * 3];
        int j = 0;
        for (int i = offset; i < offset + len; ++i) {
            int v = rgb[i];
            data[j + 0] = (byte)(v >>> 16 & 0xFF);
            data[j + 1] = (byte)(v >>> 8 & 0xFF);
            data[j + 2] = (byte)(v & 0xFF);
            j += 3;
        }
        return data;
    }

    public static int[] decompressRgbArray(byte[] data) throws IOException {
        return ZipUtil.convertByteToRgbArray(ZipUtil.decompress(data, 0));
    }

    public static int[] convertByteToRgbArray(byte[] data) {
        int[] rgb = new int[data.length / 3];
        int j = 0;
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = (data[j + 0] & 0xFF) << 16 | (data[j + 1] & 0xFF) << 8 | data[j + 2] & 0xFF;
            j += 3;
        }
        return rgb;
    }
}

