/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.HashMap;
import de.enough.polish.util.TextUtil;

public class URL {
    String host;
    String path;
    HashMap parameters;
    String result;
    boolean needsBuild = true;

    public URL(String url) {
        this(url, null);
    }

    public URL(String host, String path) {
        this.host = host;
        this.path = path;
        this.parameters = new HashMap();
    }

    public String build() {
        if (this.needsBuild) {
            StringBuffer buffer = new StringBuffer();
            StringBuffer paramsBuffer = new StringBuffer();
            buffer.append(this.host);
            if (this.path != null) {
                buffer.append(this.path);
            }
            if (this.parameters.size() > 0) {
                paramsBuffer.append('?');
                Object[] keys = this.parameters.keys();
                for (int i = 0; i < keys.length; ++i) {
                    Object key = keys[i];
                    Object value = this.parameters.get(key);
                    paramsBuffer.append(key);
                    paramsBuffer.append('=');
                    paramsBuffer.append(TextUtil.encodeUrl(value.toString()));
                    if (i >= keys.length - 1) continue;
                    paramsBuffer.append('&');
                }
                String params = paramsBuffer.toString();
                buffer.append(params);
                this.result = buffer.toString();
            }
            this.result = buffer.toString();
            this.needsBuild = false;
        }
        return this.result;
    }

    public URL addParameters(HashMap params) {
        Object[] keys = params.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object value = params.get(key);
            this.addParameter(key, value);
        }
        return this;
    }

    public HashMap getParameters() {
        return this.parameters;
    }

    public URL addParameter(String key, String value) {
        this.addParameter((Object)key, (Object)value);
        return this;
    }

    public URL addParameter(String key, int value) {
        this.addParameter((Object)key, new Integer(value));
        return this;
    }

    public URL addParameter(String key, boolean value) {
        this.addParameter((Object)key, new Boolean(value));
        return this;
    }

    public URL addParameter(String key, double value) {
        this.addParameter((Object)key, new Double(value));
        return this;
    }

    public URL addParameter(String key, float value) {
        this.addParameter((Object)key, new Float(value));
        return this;
    }

    void addParameter(Object key, Object value) {
        this.parameters.put(key, value);
        this.needsBuild = true;
    }

    public URL clearParameters() {
        this.parameters.clear();
        this.needsBuild = true;
        return this;
    }

    public String toString() {
        return this.build();
    }
}

