/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.io.Externalizable;
import de.enough.polish.util.TimePoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TimePeriod
implements Externalizable {
    public static int SCOPE_MILLISECOND = 0;
    public static int SCOPE_SECOND = 1;
    public static int SCOPE_MINUTE = 2;
    public static int SCOPE_HOUR = 3;
    public static int SCOPE_DAY = 4;
    public static int SCOPE_MONTH = 5;
    public static int SCOPE_YEAR = 6;
    private static final int VERSION = 100;
    private TimePoint start;
    private boolean includeStart;
    private TimePoint end;
    private boolean includeEnd;
    private int matchScope;

    public TimePeriod() {
    }

    public TimePeriod(String start, String end) {
        this(start, false, end, true);
    }

    public TimePeriod(String start, boolean includeStart, String end, boolean includeEnd) {
        this(TimePoint.parseRfc3339(start), includeStart, TimePoint.parseRfc3339(end), includeEnd);
    }

    public TimePeriod(TimePoint start, TimePoint end) {
        this(start, false, end, true);
    }

    public TimePeriod(TimePoint start, boolean includeStart, TimePoint end, boolean includeEnd) {
        this.start = start;
        this.includeStart = includeStart;
        this.end = end;
        this.includeEnd = includeEnd;
    }

    public TimePeriod(TimePeriod period) {
        this.start = period.start;
        this.includeStart = period.includeStart;
        this.end = period.end;
        this.includeEnd = period.includeEnd;
    }

    public void setStart(TimePoint start) {
        this.start = start;
    }

    public void setStart(TimePoint start, boolean includeStart) {
        this.start = start;
        this.includeStart = includeStart;
    }

    public void setEnd(TimePoint end) {
        this.end = end;
    }

    public void setEnd(TimePoint end, boolean includeEnd) {
        this.end = end;
        this.includeEnd = includeEnd;
    }

    public boolean matches(TimePoint timePoint) {
        return this.matches(timePoint, this.matchScope);
    }

    public boolean matches(TimePoint timePoint, int scope) {
        if (this.start != null) {
            if (timePoint.isBefore(this.start, scope)) {
                return false;
            }
            if (!this.includeStart && this.start.equals(timePoint, scope)) {
                return false;
            }
        }
        if (this.end != null) {
            if (timePoint.isAfter(this.end, scope)) {
                return false;
            }
            if (!this.includeEnd && this.end.equals(timePoint, scope)) {
                return false;
            }
        }
        return true;
    }

    public TimePoint getStart() {
        return this.start;
    }

    public TimePoint getEnd() {
        return this.end;
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version != 100) {
            throw new IOException("invalid version " + version);
        }
        this.start = new TimePoint(in);
        this.includeStart = in.readBoolean();
        this.end = new TimePoint(in);
        this.includeEnd = in.readBoolean();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(100);
        this.start.write(out);
        out.writeBoolean(this.includeStart);
        this.end.write(out);
        out.writeBoolean(this.includeEnd);
    }

    public boolean isIncludeStart() {
        return this.includeStart;
    }

    public boolean isIncludeEnd() {
        return this.includeEnd;
    }

    public void setMatchScope(int scope) {
        this.matchScope = scope;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(200);
        if (this.includeStart) {
            buffer.append('[');
        } else {
            buffer.append(']');
        }
        buffer.append(this.start);
        buffer.append(" -> ");
        buffer.append(this.end);
        if (this.includeEnd) {
            buffer.append(']');
        } else {
            buffer.append('[');
        }
        buffer.append(super.toString());
        return buffer.toString();
    }
}

