/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.WrappedText;
import java.io.UnsupportedEncodingException;
import javax.microedition.lcdui.Font;

public final class TextUtil {
    public static final int MAXLINES_UNLIMITED = Integer.MAX_VALUE;
    public static final int MAXLINES_APPENDIX_POSITION_AFTER = 0;
    public static final int MAXLINES_APPENDIX_POSITION_BEFORE = 1;
    public static final String MAXLINES_APPENDIX = "...";
    private static final String UNRESERVED = "-_.!~*'()\"";
    private static final String HEXES = "0123456789ABCDEF";
    private static final String HTML_NAMED_ENTITIES = "quot34amp38lt60gt62nbsp160iexcl161cent162pound163curren164yen165brvbar166sect167uml168copy169ordf170laquo171not172shy173reg174macr175deg176plusmn177sup2178sup3179acute180micro181para182middot183cedil184sup1185ordm186raquo187frac14188frac12189frac34190iquest191Agrave192Aacute193Acirc194Atilde195Auml196Aring197AElig198Ccedil199Egrave200Eacute201Ecirc202Euml203Igrave204Iacute205Icirc206Iuml207ETH208Ntilde209Ograve210Oacute211Ocirc212Otilde213Ouml214times215Oslash216Ugrave217Uacute218Ucirc219Uuml220Yacute221THORN222szlig223agrave224aacute225acirc226atilde227auml228aring229aelig230ccedil231egrave232eacute233ecirc234euml235igrave236iacute237icirc238iuml239eth240ntilde241ograve242oacute243ocirc244otilde245ouml246divide247oslash248ugrave249uacute250ucirc251uuml252yacute253thorn254yuml255";

    public static String[] split(String value, char delimiter) {
        char[] valueChars = value.toCharArray();
        int lastIndex = 0;
        ArrayList strings = null;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            if (c != delimiter) continue;
            if (strings == null) {
                strings = new ArrayList();
            }
            strings.add(new String(valueChars, lastIndex, i - lastIndex));
            lastIndex = i + 1;
        }
        if (strings == null) {
            return new String[]{value};
        }
        strings.add(new String(valueChars, lastIndex, valueChars.length - lastIndex));
        return (String[])strings.toArray(new String[strings.size()]);
    }

    public static String[] splitAndTrim(String value, char delimiter) {
        String[] result = TextUtil.split(value, delimiter);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static String[] split(String value, char delimiter, int numberOfChunks) {
        char[] valueChars = value.toCharArray();
        int lastIndex = 0;
        String[] chunks = new String[numberOfChunks];
        int chunkIndex = 0;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            if (c != delimiter) continue;
            chunks[chunkIndex] = value.substring(lastIndex, i);
            lastIndex = i + 1;
            if (++chunkIndex == numberOfChunks) break;
        }
        if (chunkIndex < numberOfChunks) {
            chunks[chunkIndex] = value.substring(lastIndex, valueChars.length);
        }
        return chunks;
    }

    public static String[] split(String value, Font font, int firstLineWidth, int lineWidth) {
        return TextUtil.wrap(value, font, firstLineWidth, lineWidth, Integer.MAX_VALUE, null, 0);
    }

    public static String[] wrap(String value, Font font, int firstLineWidth, int lineWidth) {
        return TextUtil.wrap(value, font, firstLineWidth, lineWidth, Integer.MAX_VALUE, null, 0);
    }

    public static String[] wrap(String value, Font font, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix) {
        return TextUtil.wrap(value, font, firstLineWidth, lineWidth, maxLines, maxLinesAppendix, 0);
    }

    public static String[] wrap(String value, Font font, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix, int maxLinesAppendixPosition) {
        WrappedText result = new WrappedText();
        TextUtil.wrap(value, font, firstLineWidth, lineWidth, maxLines, maxLinesAppendix, maxLinesAppendixPosition, result);
        return result.getLines();
    }

    public static void wrap(String value, Font font, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix, int maxLinesAppendixPosition, WrappedText result) {
        if (firstLineWidth <= 0 || lineWidth <= 0) {
            Debug.debug("error", "de.enough.polish.util.TextUtil", 267, "INVALID LINE WIDTH FOR SPLITTING " + firstLineWidth + " / " + lineWidth + " ( for string " + value + ")");
            try {
                throw new RuntimeException("INVALID LINE WIDTH FOR SPLITTING " + firstLineWidth + " / " + lineWidth + " ( for string " + value + ")");
            }
            catch (Exception e) {
                e.printStackTrace();
                int width = font.stringWidth(value);
                result.addLine(value, width);
                return;
            }
        }
        boolean hasLineBreaks = value.indexOf(10) != -1;
        int completeWidth = font.stringWidth(value);
        if (completeWidth <= firstLineWidth && !hasLineBreaks) {
            result.addLine(value, completeWidth);
            return;
        }
        if (!hasLineBreaks) {
            TextUtil.wrap(value, font, completeWidth, firstLineWidth, lineWidth, result, maxLines, maxLinesAppendixPosition);
        } else {
            char[] valueChars = value.toCharArray();
            int lastIndex = 0;
            int c = 32;
            int lineBreakCount = 0;
            for (int i = 0; i < valueChars.length; ++i) {
                boolean isCRLF;
                c = valueChars[i];
                boolean bl = isCRLF = c == 13 && i < valueChars.length - 1 && valueChars[i + 1] == '\n';
                if (c != 10 && i != valueChars.length - 1 && !isCRLF) continue;
                ++lineBreakCount;
                String line = null;
                line = i == valueChars.length - 1 ? new String(valueChars, lastIndex, i + 1 - lastIndex) : new String(valueChars, lastIndex, i - lastIndex);
                completeWidth = font.stringWidth(line);
                if (completeWidth <= firstLineWidth) {
                    result.addLine(line, completeWidth);
                    if (result.size() == maxLines) {
                        break;
                    }
                } else {
                    TextUtil.wrap(line, font, completeWidth, firstLineWidth, lineWidth, result, maxLines, maxLinesAppendixPosition);
                }
                if (isCRLF) {
                    ++i;
                }
                lastIndex = i + 1;
                firstLineWidth = lineWidth;
            }
            if (lineBreakCount > 1 && (c == 10 || c == 10) && result.size() != maxLines) {
                result.addLine("", 0);
            }
        }
        if (result.size() >= maxLines) {
            if (maxLinesAppendix == null) {
                maxLinesAppendix = MAXLINES_APPENDIX;
            }
            TextUtil.addAppendix(font, firstLineWidth, maxLinesAppendix, maxLinesAppendixPosition, maxLines - 1, result);
            while (result.size() > maxLines) {
                result.removeLine(result.size() - 1);
            }
        }
    }

    public static void split(String value, Font font, int completeWidth, int firstLineWidth, int lineWidth, WrappedText result) {
        TextUtil.wrap(value, font, completeWidth, firstLineWidth, lineWidth, result, Integer.MAX_VALUE, 0);
    }

    public static void wrap(String value, Font font, int completeWidth, int firstLineWidth, int lineWidth, WrappedText list, int maxLines, int maxLinesAppendixPosition) {
        if (maxLinesAppendixPosition == 1 && maxLines == 1) {
            list.addLine(value, 0);
            return;
        }
        int lastLineIndex = maxLines - 1;
        char[] valueChars = value.toCharArray();
        int startPos = 0;
        int lastSpacePos = -1;
        int lastSpacePosLineWidth = 0;
        int currentLineWidth = 0;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            currentLineWidth += font.charWidth(c);
            if (c == '\n') {
                list.addLine(new String(valueChars, startPos, i - startPos), currentLineWidth);
                lastSpacePos = -1;
                startPos = i + 1;
                currentLineWidth = 0;
                firstLineWidth = lineWidth;
                i = startPos;
                continue;
            }
            if (currentLineWidth >= firstLineWidth && i > 0) {
                int stringWidth;
                String line;
                if (list.size() == lastLineIndex) {
                    line = new String(valueChars, startPos, valueChars.length - startPos);
                    currentLineWidth = font.stringWidth(line);
                    list.addLine(line, currentLineWidth);
                    break;
                }
                if (c == ' ' || c == '\t') {
                    line = new String(valueChars, startPos, i - startPos);
                    stringWidth = font.stringWidth(line);
                    if (lastSpacePos != -1 && stringWidth > currentLineWidth) {
                        if (i > startPos + 1) {
                            // empty if block
                        }
                        line = new String(valueChars, startPos, lastSpacePos - startPos);
                        stringWidth = font.stringWidth(line);
                        list.addLine(line, stringWidth);
                        startPos = lastSpacePos;
                        lastSpacePos = --i;
                        lastSpacePosLineWidth = currentLineWidth -= lastSpacePosLineWidth;
                    } else {
                        list.addLine(line, stringWidth);
                        startPos = ++i;
                        currentLineWidth = 0;
                        lastSpacePos = -1;
                    }
                } else if (lastSpacePos == -1) {
                    line = new String(valueChars, startPos, i - startPos);
                    stringWidth = font.stringWidth(line);
                    list.addLine(line, stringWidth);
                    startPos = i;
                    currentLineWidth = font.charWidth(valueChars[i]);
                } else {
                    currentLineWidth -= lastSpacePosLineWidth;
                    line = new String(valueChars, startPos, lastSpacePos - startPos);
                    stringWidth = font.stringWidth(line);
                    list.addLine(line, stringWidth);
                    startPos = lastSpacePos + 1;
                    lastSpacePos = -1;
                }
                firstLineWidth = lineWidth;
                continue;
            }
            if (c != ' ' && c != '\t') continue;
            lastSpacePos = i;
            lastSpacePosLineWidth = currentLineWidth;
        }
        if (list.size() != maxLines) {
            String tail = new String(valueChars, startPos, valueChars.length - startPos);
            currentLineWidth = font.stringWidth(tail);
            list.addLine(tail, currentLineWidth);
        }
    }

    private static void addAppendix(Font font, int availWidth, String appendix, int position, int index, WrappedText result) {
        try {
            int appendixWidth = font.stringWidth(appendix);
            String line = result.getLine(index);
            int lineWidth = result.getLineWidth(index);
            int completeWidth = lineWidth + appendixWidth;
            if (availWidth < appendixWidth) {
                line = appendix;
                completeWidth = appendixWidth;
                while (completeWidth > availWidth) {
                    if (position == 0) {
                        line = line.substring(0, line.length() - 1);
                    } else if (position == 1) {
                        line = line.substring(1);
                    }
                    completeWidth = font.stringWidth(line);
                }
                result.setLine(index, line, completeWidth);
                return;
            }
            if (lineWidth > availWidth) {
                while (completeWidth > availWidth) {
                    if (position == 0) {
                        line = line.substring(0, line.length() - 1);
                    } else if (position == 1) {
                        line = line.substring(1);
                    }
                    completeWidth = font.stringWidth(line) + appendixWidth;
                }
                if (position == 0) {
                    result.setLine(index, line + appendix, completeWidth);
                    return;
                }
                result.setLine(index, appendix + line, completeWidth);
                return;
            }
            result.setLine(index, line, completeWidth);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Debug.debug("error", "de.enough.polish.util.TextUtil", 597, (Object)"Unable to add max-lines-appendiz", e);
            return;
        }
    }

    private static char toHexChar(int digitValue) {
        if (digitValue < 10) {
            return (char)(48 + digitValue);
        }
        return (char)(65 + (digitValue - 10));
    }

    public static String encodeUrl(String url) {
        StringBuffer encodedUrl = new StringBuffer();
        int len = url.length();
        for (int i = 0; i < len; ++i) {
            char c = url.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                encodedUrl.append(c);
                continue;
            }
            int imark = UNRESERVED.indexOf(c);
            if (imark >= 0) {
                encodedUrl.append(c);
                continue;
            }
            encodedUrl.append('%');
            encodedUrl.append(TextUtil.toHexChar((c & 0xF0) >> 4));
            encodedUrl.append(TextUtil.toHexChar(c & 0xF));
        }
        return encodedUrl.toString();
    }

    public static String encodeForXmlParser(String text) {
        int len = text.length();
        StringBuffer buffer = new StringBuffer(len + 10);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                buffer.append("&gt;");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String replace(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            StringBuffer buffer = new StringBuffer();
            int lastPos = 0;
            do {
                buffer.append(input.substring(lastPos, pos)).append(replacement);
            } while ((pos = input.indexOf(search, lastPos = pos + search.length())) != -1);
            buffer.append(input.substring(lastPos));
            input = buffer.toString();
        }
        return input;
    }

    public static String replaceFirst(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            input = input.substring(0, pos) + replacement + input.substring(pos + search.length());
        }
        return input;
    }

    public static String replaceLast(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            int lastPos = pos;
            while ((pos = input.indexOf(search, lastPos + 1)) != -1) {
                lastPos = pos;
            }
            input = input.substring(0, lastPos) + replacement + input.substring(lastPos + search.length());
        }
        return input;
    }

    public static int lastIndexOf(String text, String match) {
        int lastIndex = -1;
        int index = text.indexOf(match);
        while (index != -1) {
            lastIndex = index;
            index = text.indexOf(match, lastIndex + 1);
        }
        return lastIndex;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1.equalsIgnoreCase(str2);
    }

    public static String reverseForRtlLanguage(String input) {
        StringBuffer output = new StringBuffer(input.length());
        StringBuffer ltrCharacters = new StringBuffer();
        boolean isCurrRTL = true;
        int size = input.length();
        int index = size - 1;
        while (index >= 0) {
            char nextChr;
            char curr;
            while (isCurrRTL && index >= 0) {
                curr = input.charAt(index);
                nextChr = '\u0000';
                nextChr = index > 0 ? input.charAt(index - 1) : curr;
                if (TextUtil.isEnglishChar(curr) || TextUtil.isEnglishChar(nextChr)) {
                    isCurrRTL = false;
                    continue;
                }
                if (curr == '(') {
                    output.append(')');
                } else if (curr == ')') {
                    output.append('(');
                } else {
                    output.append(curr);
                }
                --index;
            }
            ltrCharacters.delete(0, ltrCharacters.length());
            while (!isCurrRTL && index >= 0) {
                curr = input.charAt(index);
                nextChr = '\u0000';
                nextChr = index > 0 ? input.charAt(index - 1) : curr;
                if (TextUtil.isEnglishChar(curr) || TextUtil.isEnglishChar(nextChr)) {
                    ltrCharacters.insert(0, curr);
                    --index;
                    continue;
                }
                isCurrRTL = true;
            }
            output.append(ltrCharacters);
        }
        return output.toString();
    }

    private static boolean isEnglishChar(char chr) {
        return chr < '\u0080' && (chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z' || chr >= '0' && chr <= '9' || chr == '+');
    }

    public static String encodeAsQuotedPrintable(String clearText, String enc) throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        int lastIndex = clearText.length() - 1;
        int numberCharsInRow = 0;
        for (int i = 0; i <= lastIndex; ++i) {
            char character = clearText.charAt(i);
            if (character == '=') {
                numberCharsInRow += TextUtil.encodeCharacterAsQP(buffer, character, enc);
            } else if ('!' <= character && character <= '<' || '>' <= character && character <= '~') {
                buffer.append(character);
                ++numberCharsInRow;
            } else if (character == '\t' || character == ' ') {
                if (i + 2 <= lastIndex && clearText.charAt(i + 1) == '\r' && clearText.charAt(i + 2) == '\n') {
                    numberCharsInRow += TextUtil.encodeCharacterAsQP(buffer, character, enc);
                } else {
                    buffer.append(character);
                    ++numberCharsInRow;
                }
            } else if (i + 1 <= lastIndex && character == '\r' && clearText.charAt(i + 1) == '\n') {
                buffer.append('\r');
            } else if (i - 1 >= 0 && character == '\n' && clearText.charAt(i - 1) == '\r') {
                buffer.append('\n');
                numberCharsInRow = 0;
            } else {
                numberCharsInRow += TextUtil.encodeCharacterAsQP(buffer, character, enc);
            }
            if (numberCharsInRow <= 76) continue;
            int lastIndexOfBuffer = buffer.length() - 1;
            int numberOfCharsOverflowingLine = numberCharsInRow - 76;
            int lastIndexOnLine = lastIndexOfBuffer - numberOfCharsOverflowingLine;
            buffer.insert(lastIndexOnLine, "=\r\n");
            numberCharsInRow = numberOfCharsOverflowingLine + 1;
        }
        return buffer.toString();
    }

    private static int encodeCharacterAsQP(StringBuffer buffer, char character, String encoding) throws UnsupportedEncodingException {
        int numberCharactersGenerated = 0;
        byte[] bytes = new String(new char[]{character}).getBytes(encoding);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buffer.append("=");
            buffer.append(HEXES.charAt((b & 0xF0) >> 4));
            buffer.append(HEXES.charAt(b & 0xF));
            numberCharactersGenerated += 3;
        }
        return numberCharactersGenerated;
    }

    public static char resolveNamedHtmlEntity(String name) {
        int index = HTML_NAMED_ENTITIES.indexOf(name);
        if (index == -1) {
            return '?';
        }
        StringBuffer digits = new StringBuffer(5);
        char c = HTML_NAMED_ENTITIES.charAt(index += name.length());
        while (Character.isDigit(c)) {
            digits.append(c);
            c = HTML_NAMED_ENTITIES.charAt(++index);
        }
        try {
            int value = Integer.parseInt(digits.toString());
            return (char)value;
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.util.TextUtil", 997, (Object)("Unable to resolve html entity " + name), e);
            return '?';
        }
    }

    public static String unescapeHtmlEntities(String input) {
        int length = input.length();
        StringBuffer output = new StringBuffer(length);
        StringBuffer entity = new StringBuffer(7);
        for (int i = 0; i < length; ++i) {
            int c = input.charAt(i);
            if (c == 38) {
                int start = i;
                while (++i < length && i < start + 10) {
                    char c2 = input.charAt(i);
                    c = c2;
                    if (c2 == ';') break;
                    entity.append((char)c);
                }
                if (c == 59) {
                    c = entity.charAt(0);
                    if (c == 35) {
                        entity.delete(0, 1);
                        try {
                            c = (char)Integer.parseInt(entity.toString());
                        }
                        catch (Exception e) {
                            Debug.debug("error", "de.enough.polish.util.TextUtil", 1030, (Object)("Unable to parse HTML entity &#" + entity.toString() + "; "), e);
                            c = 63;
                        }
                    } else {
                        c = TextUtil.resolveNamedHtmlEntity(entity.toString());
                    }
                } else {
                    i = start;
                    c = 38;
                }
                entity.delete(0, entity.length());
            }
            output.append((char)c);
        }
        return output.toString();
    }
}

