/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.io.Externalizable;
import de.enough.polish.util.ArrayList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class KeyValueList
implements Externalizable {
    public final ArrayList keys;
    public final ArrayList values;

    public KeyValueList() {
        this(10, 75);
    }

    public KeyValueList(int initialCapacity) {
        this(initialCapacity, 75);
    }

    public KeyValueList(int initialCapacity, int growthFactor) {
        this.keys = new ArrayList(initialCapacity, growthFactor);
        this.values = new ArrayList(initialCapacity, growthFactor);
    }

    public int size() {
        return this.keys.size();
    }

    public boolean containsKey(Object element) {
        return this.keys.contains(element);
    }

    public boolean containsValue(Object element) {
        return this.values.contains(element);
    }

    public int indexOfKey(Object element) {
        return this.keys.indexOf(element);
    }

    public int indexOfValue(Object element) {
        return this.values.indexOf(element);
    }

    public Object getKey(int index) {
        return this.keys.get(index);
    }

    public Object getValue(int index) {
        return this.values.get(index);
    }

    public Object remove(int index) {
        this.values.remove(index);
        return this.keys.remove(index);
    }

    public boolean remove(Object element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        int index = this.indexOfKey(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    public void add(Object key, Object value) {
        this.keys.add(key);
        this.values.add(value);
    }

    public void add(int index, Object key, Object value) {
        this.keys.add(index, key);
        this.values.add(index, value);
    }

    public Object set(int index, Object key, Object value) {
        this.values.set(index, value);
        return this.keys.set(index, key);
    }

    public Object[] getInternalKeyArray() {
        return this.keys.getInternalArray();
    }

    public Object[] getInternalValueArray() {
        return this.keys.getInternalArray();
    }

    public void read(DataInputStream in) throws IOException {
        this.keys.read(in);
        this.values.read(in);
    }

    public void write(DataOutputStream out) throws IOException {
        this.keys.write(out);
        this.values.write(out);
    }
}

